/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import oracle.cloud.paas.model.ApplicationState;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Property;

@XmlRootElement(name="Application", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlType(name="ApplicationType", namespace="http://xmlns.oracle.com/cloud/paas/1.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Application {
    @XmlElement(name="GroupName", required=true)
    private String groupName;
    @XmlElement(name="DomainName")
    private String domainName;
    @XmlElement(name="InstanceName", required=true)
    private String instanceName;
    @XmlElement(name="ApplicationName", required=true)
    private String applicationName;
    @XmlElement(name="Type", required=true)
    private ApplicationType type;
    @XmlElement(name="State", required=false)
    private ApplicationState state;
    @XmlElementWrapper(name="ApplicationUrls")
    @XmlElement(name="Url", required=false)
    private List<String> appUrls = new ArrayList<String>();
    @XmlElementWrapper(name="Properties")
    @XmlElement(name="Property", required=false)
    private List<Property> properties = new ArrayList<Property>();

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
        this.domainName = groupName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
        this.groupName = domainName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationId) {
        this.applicationName = applicationId;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public void setType(ApplicationType type) {
        this.type = type;
    }

    public ApplicationState getState() {
        return this.state;
    }

    public void setState(ApplicationState state) {
        this.state = state;
    }

    public List<String> getApplicationUrls() {
        return this.appUrls;
    }

    public void setApplicationUrls(List<String> applicationUrls) {
        this.appUrls = applicationUrls;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public String createNormalizedFileName() {
        return this.getApplicationName().replaceAll("[^A-Za-z0-9]", "_") + "." + this.getType().name().toLowerCase();
    }

    public String toStringFull() {
        StringBuffer dp = new StringBuffer("ApplicationDeploymentType(");
        dp.append("instanceName=");
        dp.append(this.instanceName);
        dp.append("; ");
        dp.append("applicationId=");
        dp.append(this.applicationName);
        dp.append("; ");
        dp.append("; ");
        dp.append("state=");
        dp.append((Object)this.state);
        if (!this.properties.isEmpty()) {
            dp.append("\n\tProperties [");
            for (Property property : this.properties) {
                dp.append(property.getName());
                dp.append("=");
                dp.append(property.getValue());
                dp.append("; ");
            }
            dp.deleteCharAt(dp.lastIndexOf(";"));
            dp.append("]");
        }
        dp.append(")");
        return dp.toString();
    }
}

