/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.internal.Helper;
import oracle.cloud.paas.internal.TrustTokenProvider;
import oracle.security.jps.service.JpsServiceLocator;
import oracle.security.jps.service.trust.TrustService;
import oracle.security.jps.service.trust.token.TokenContext;
import oracle.security.jps.service.trust.token.TokenException;
import oracle.security.jps.service.trust.token.TokenManager;
import oracle.security.jps.service.trust.token.TokenUtil;
import oracle.security.xml.GenericToken;
import oracle.security.xml.Token;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.wss.username.UsernameToken;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;

public final class TrustTokenProviderImpl
implements TrustTokenProvider {
    @Override
    public String generateToken(String user) {
        try {
            TrustService trustService = (TrustService)JpsServiceLocator.getServiceLocator().lookup(TrustService.class);
            final TokenManager tokenMgr = trustService.getTokenManager();
            final TokenContext ctx = tokenMgr.createTokenContext("urn:oracle:security:jps:trustservice:embedded");
            UsernameToken ut = WSSTokenUtils.createUsernameToken((String)"wsuid", (String)user);
            GenericToken gtok = new GenericToken((XMLElement)ut);
            ctx.setSecurityToken((Token)gtok);
            ctx.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
            Map ctxProperties = ctx.getOtherProperties();
            ctxProperties.put("trust.confirmationMethod", "urn:oasis:names:tc:SAML:2.0:cm:bearer");
            AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        tokenMgr.issueToken(ctx);
                    }
                    catch (TokenException e) {
                        throw new ManagerException(e.getMessage(), e);
                    }
                    return null;
                }
            });
            Token token = ctx.getSecurityToken();
            return TokenUtil.encodeToken((Token)token);
        }
        catch (Throwable e) {
            throw new ManagerException("Error creating SAML token for identity propagation: " + Helper.getCauseInfo(e), e);
        }
    }
}

