/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URL;
import java.util.List;
import oracle.cloud.paas.api.ServiceManager;
import oracle.cloud.paas.internal.JobManagerImpl;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.Property;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.model.ServiceInstances;
import oracle.cloud.paas.model.ServiceSize;
import oracle.cloud.paas.model.ServiceState;

public class ServiceManagerImpl
extends JobManagerImpl
implements ServiceManager {
    public ServiceManagerImpl(URL url, String identityDomain, String user, String password) {
        super(url, identityDomain, user, password, null);
    }

    public Job createServiceInstance(String groupName, String instanceName, ServiceSize size, List<Property> properties, List<Association> associations) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        ServiceInstance instance = new ServiceInstance();
        instance.setGroupName(groupName);
        instance.setInstanceName(instanceName);
        instance.setSize(size);
        instance.setProperties(properties);
        instance.setAssociations(associations);
        WebResource resource = this.createInstanceResource(groupName);
        logger.fine("createServiceInstance REST URI: " + resource.getURI());
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml", "text/plain"})).post(ClientResponse.class, (Object)instance);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("createServiceInstance", response);
    }

    public Job createServiceInstance(String groupName, String instanceName, ServiceInstance instance) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        instance.setGroupName(groupName);
        instance.setInstanceName(instanceName);
        WebResource resource = this.createInstanceResource(groupName);
        logger.fine("createServiceInstance REST URI: " + resource.getURI());
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml", "text/plain"})).post(ClientResponse.class, (Object)instance);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("createServiceInstance", response);
    }

    public Job destroyServiceInstance(String groupName, String instanceName, String archiveSubDir) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.createInstanceResource(groupName, instanceName);
        if (archiveSubDir != null) {
            resource = resource.queryParam("ArchiveSubDir", archiveSubDir);
        }
        logger.fine("destroyServiceInstance REST URI: " + resource.getURI());
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).delete(ClientResponse.class);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("destroyServiceInstance", response);
    }

    public Job destroyServiceInstance(String groupName, String instanceName) {
        return this.destroyServiceInstance(groupName, instanceName, null);
    }

    public Job scaleServiceInstance(String groupName, String instanceName, ServiceSize newSize) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        ServiceInstance instance = this.describeServiceInstance(groupName, instanceName);
        instance.setSize(newSize);
        return this.updateServiceInstance(groupName, instanceName, instance);
    }

    public Job associateServiceInstance(String groupName, String instanceName, Association association) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.createInstanceResource(groupName, instanceName).path("association").path(association.getTargetInstanceName());
        logger.fine("associateServiceInstance REST URI: " + resource.getURI());
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml", "text/plain"})).put(ClientResponse.class, (Object)association);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("associateServiceInstance", response);
    }

    public Job disassociateServiceInstance(String groupName, String instanceName, String associationName) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        this.assertPathParameter("associationName", associationName);
        WebResource resource = this.createInstanceResource(groupName, instanceName).path("association").path(associationName);
        logger.fine("disassociateServiceInstance REST URI: " + resource.getURI());
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).delete(ClientResponse.class);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("disassociateServiceInstance", response);
    }

    public Job enableServiceInstance(String groupName, String instanceName) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        ServiceInstance instance = new ServiceInstance();
        instance.setGroupName(groupName);
        instance.setInstanceName(instanceName);
        instance.setState(ServiceState.ACTIVE);
        return this.updateServiceInstance(groupName, instanceName, instance);
    }

    public Job disableServiceInstance(String groupName, String instanceName) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        ServiceInstance instance = new ServiceInstance();
        instance.setGroupName(groupName);
        instance.setInstanceName(instanceName);
        instance.setState(ServiceState.ADMIN);
        return this.updateServiceInstance(groupName, instanceName, instance);
    }

    public ServiceInstance describeServiceInstance(String groupName, String instanceName) {
        this.assertPathParameter("groupName", groupName);
        this.assertPathParameter("instanceName", instanceName);
        WebResource resource = this.createInstanceResource(groupName, instanceName);
        logger.fine("describeServiceInstance REST URI: " + resource.getURI());
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/xml", "text/plain"}).get(ClientResponse.class);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return (ServiceInstance)response.getEntity(ServiceInstance.class);
        }
        throw this.convertClientResponseToException("describeServiceInstance", response);
    }

    public List<ServiceInstance> listServiceInstances(String groupName) {
        ClientResponse response = this.getPublicManagerHelper().listServiceInstances(groupName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((ServiceInstances)response.getEntity(ServiceInstances.class)).getServiceInstances();
        }
        throw this.convertClientResponseToException("listServiceInstances", response);
    }
}

