/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.cloud.paas.internal.AbstractManagerImpl;
import oracle.cloud.paas.internal.Helper;
import oracle.cloud.paas.model.Files;
import oracle.cloud.paas.model.ListWrapper;
import oracle.cloud.paas.model.PaasFile;
import oracle.cloud.paas.model.java.CredentialInfo;
import oracle.cloud.paas.model.java.KeyStoreEntryInfo;
import oracle.cloud.paas.model.java.KeyStoreEntryInfoList;
import oracle.nuviaq.common.XmlUtil;

public class RequestIdFilter
extends ClientFilter {
    private static Logger logger = Logger.getLogger("oracle.nuviaq");
    private final AbstractManagerImpl manager;

    public RequestIdFilter(AbstractManagerImpl manager) {
        this.manager = manager;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        Object obj;
        String idDomain;
        String requestId = this.manager.getRequestId();
        if (requestId != null) {
            request.getHeaders().add((Object)"X-OPC-Request-Id", (Object)requestId);
        }
        if ((idDomain = this.manager.getIdentityDomain()) != null) {
            request.getHeaders().add((Object)"X-ID-TENANT-NAME", (Object)idDomain);
        }
        if (!(!this.manager.simv1 || (obj = request.getEntity()) == null || obj instanceof String || obj instanceof byte[] || obj instanceof InputStream || obj instanceof KeyStoreEntryInfoList || obj instanceof KeyStoreEntryInfo || obj instanceof ListWrapper || obj instanceof CredentialInfo || obj instanceof Files || obj instanceof PaasFile)) {
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
                Marshaller marshaller = jc.createMarshaller();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                marshaller.marshal(obj, (OutputStream)bos);
                String str = bos.toString();
                str = XmlUtil.unfixXml(str);
                request.setEntity((Object)str);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        ClientResponse response = this.getNext().handle(request);
        if (this.manager.simv1 && MediaType.APPLICATION_XML_TYPE.equals((Object)response.getType())) {
            byte[] bytes = this.readEntity(response);
            String str = XmlUtil.fixXml(new String(bytes));
            response.setEntityInputStream((InputStream)new ByteArrayInputStream(str.getBytes()));
        }
        return response;
    }

    private byte[] readEntity(ClientResponse response) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = response.getEntityInputStream();
        try {
            int read;
            byte[] data = new byte[2048];
            while ((read = in.read(data)) != -1) {
                out.write(data, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Helper.safeClose((Closeable)in, logger);
            Helper.safeClose((Closeable)out, logger);
        }
    }
}

