/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.internal.JobManagerImpl;
import oracle.cloud.paas.internal.TrustTokenProvider;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.Libraries;
import oracle.cloud.paas.model.Library;

public class LibraryManagerImpl
extends JobManagerImpl
implements LibraryManager {
    public LibraryManagerImpl(URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        super(url, identityDomain, user, password, clientProperties);
    }

    public LibraryManagerImpl(URL url, String identityDomain, String user, TrustTokenProvider provider, Map<String, Object> clientProperties) {
        super(url, identityDomain, user, provider, clientProperties);
    }

    @Override
    public Job deployLibrary(Library library, InputStream libArchive) {
        ClientResponse response = this.getPublicManagerHelper().deployLibrary(library, libArchive);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("deployLibrary", response);
    }

    @Override
    public Job redeployLibrary(Library library, InputStream libArchive) {
        ClientResponse response = this.getPublicManagerHelper().redeployLibrary(library, libArchive);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("redeployLibrary", response);
    }

    @Override
    public Job undeployLibrary(Library library) {
        ClientResponse response = this.getPublicManagerHelper().undeployLibrary(library);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("undeployLibrary", response);
    }

    @Override
    public Library describeLibrary(String domainName, String instanceName, String libName, String specVersion, String implVersion) {
        ClientResponse response = this.getPublicManagerHelper().describeLibrary(domainName, instanceName, libName, specVersion, implVersion);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return (Library)response.getEntity(Library.class);
        }
        throw this.convertClientResponseToException("describeLibrary", response);
    }

    @Override
    public List<Library> listLibraries(String domainName, String instanceName) {
        ClientResponse response = this.getPublicManagerHelper().listLibraries(domainName, instanceName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Libraries)response.getEntity(Libraries.class)).getLibraries();
        }
        throw this.convertClientResponseToException("listLibraries", response);
    }

    @Override
    public List<String> getReferencingApplicationNames(Library library) {
        ClientResponse response = this.getPublicManagerHelper().getReferencingApplicationNames(library);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            String refs = (String)response.getEntity(String.class);
            return this.convertAppRefsStringToList(refs);
        }
        throw this.convertClientResponseToException("getReferencingApplicationNames", response);
    }

    @Override
    public void release() {
        if (this.getClient() != null) {
            this.getClient().destroy();
            this.setClient(null);
        }
    }

    private List<String> convertAppRefsStringToList(String refs) {
        ArrayList<String> refList = new ArrayList<String>();
        if (refs != null) {
            StringTokenizer st = new StringTokenizer(refs, ",");
            while (st.hasMoreElements()) {
                refList.add((String)st.nextElement());
            }
        }
        return refList;
    }
}

