/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import java.net.URL;
import java.util.Map;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.Connection;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.internal.ApplicationManagerImpl;
import oracle.cloud.paas.internal.LibraryManagerImpl;
import oracle.cloud.paas.internal.TrustTokenProvider;

public class ConnectionImpl
implements Connection {
    private ApplicationManager applicationManager = null;
    private LibraryManager libraryManager = null;

    public ConnectionImpl(URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        this.applicationManager = new ApplicationManagerImpl(url, identityDomain, user, password, clientProperties);
        this.libraryManager = new LibraryManagerImpl(url, identityDomain, user, password, clientProperties);
    }

    public ConnectionImpl(URL url, String identityDomain, String user, TrustTokenProvider provider, Map<String, Object> clientProperties) {
        this.applicationManager = new ApplicationManagerImpl(url, identityDomain, user, provider, clientProperties);
        this.libraryManager = new LibraryManagerImpl(url, identityDomain, user, provider, clientProperties);
    }

    @Override
    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    @Override
    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    @Override
    public void release() {
        if (this.applicationManager != null) {
            this.applicationManager.release();
            this.applicationManager = null;
        }
        if (this.libraryManager != null) {
            this.libraryManager.release();
            this.libraryManager = null;
        }
    }
}

