/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.internal.JobManagerImpl;
import oracle.cloud.paas.internal.TrustTokenProvider;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.ApplicationState;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Applications;
import oracle.cloud.paas.model.DataSource;
import oracle.cloud.paas.model.DataSources;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.Metric;
import oracle.cloud.paas.model.Metrics;
import oracle.cloud.paas.model.Server;
import oracle.cloud.paas.model.Servers;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.model.ServiceInstances;
import oracle.cloud.paas.model.WebModuleInstance;
import oracle.cloud.paas.model.WebModuleInstances;
import oracle.cloud.paas.model.WorkManagerInstance;
import oracle.cloud.paas.model.WorkManagerInstances;

public class ApplicationManagerImpl
extends JobManagerImpl
implements ApplicationManager {
    public ApplicationManagerImpl(URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        super(url, identityDomain, user, password, clientProperties);
    }

    public ApplicationManagerImpl(URL url, String identityDomain, String user, TrustTokenProvider provider, Map<String, Object> clientProperties) {
        super(url, identityDomain, user, provider, clientProperties);
    }

    @Override
    public ServiceInstance describeServiceInstance(String groupName, String instanceName) {
        ClientResponse response = this.getPublicManagerHelper().describeServiceInstance(groupName, instanceName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return (ServiceInstance)response.getEntity(ServiceInstance.class);
        }
        throw this.convertClientResponseToException("describeServiceInstance", response);
    }

    @Override
    public List<ServiceInstance> listServiceInstances(String groupName) {
        ClientResponse response = this.getPublicManagerHelper().listServiceInstances(groupName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((ServiceInstances)response.getEntity(ServiceInstances.class)).getServiceInstances();
        }
        throw this.convertClientResponseToException("listServiceInstances", response);
    }

    @Override
    public List<Server> listServers(String groupName, String instanceName) {
        ClientResponse response = this.getPublicManagerHelper().listServers(groupName, instanceName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Servers)response.getEntity(Servers.class)).getServers();
        }
        throw this.convertClientResponseToException("listServers", response);
    }

    @Override
    public Server describeServer(String groupName, String instanceName, String serverName) {
        ClientResponse response = this.getPublicManagerHelper().describeServer(groupName, instanceName, serverName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return (Server)response.getEntity(Server.class);
        }
        throw this.convertClientResponseToException("describeServer", response);
    }

    @Override
    public List<DataSource> listDataSources(String groupName, String instanceName) {
        ClientResponse response = this.getPublicManagerHelper().listDataSources(groupName, instanceName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((DataSources)response.getEntity(DataSources.class)).getDataSources();
        }
        throw this.convertClientResponseToException("listDataSources", response);
    }

    @Override
    public DataSource describeDataSource(String groupName, String instanceName, String dataSourceName) {
        ClientResponse response = this.getPublicManagerHelper().describeDataSource(groupName, instanceName, dataSourceName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return (DataSource)response.getEntity(DataSource.class);
        }
        throw this.convertClientResponseToException("describeDataSource", response);
    }

    @Override
    public Job deployApplication(String groupName, String instanceName, String applicationName, ApplicationType type, InputStream applicationArchive) {
        return this.deployApplication(groupName, instanceName, applicationName, type, applicationArchive, ApplicationState.STATE_ACTIVE);
    }

    @Override
    public Job deployApplication(String groupName, String instanceName, String applicationName, ApplicationType type, InputStream applicationArchive, ApplicationState initialState) {
        ClientResponse response = this.getPublicManagerHelper().deployApplication(groupName, instanceName, applicationName, type, applicationArchive, initialState);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("deployApplication", response);
    }

    @Override
    public Job redeployApplication(String groupName, String instanceName, String applicationName, InputStream applicationArchive) {
        return this.redeployApplication(groupName, instanceName, applicationName, applicationArchive, ApplicationState.STATE_ACTIVE);
    }

    @Override
    public Job redeployApplication(String groupName, String instanceName, String applicationName, InputStream applicationArchive, ApplicationState initialState) {
        ClientResponse response = this.getPublicManagerHelper().redeployApplication(groupName, instanceName, applicationName, applicationArchive, initialState);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("redeployApplication", response);
    }

    @Override
    public Job undeployApplication(String groupName, String instanceName, String applicationName) {
        ClientResponse response = this.getPublicManagerHelper().undeployApplication(groupName, instanceName, applicationName);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("undeployApplication", response);
    }

    @Override
    public Application describeApplication(String groupName, String instanceName, String applicationName) {
        ClientResponse response = this.getPublicManagerHelper().describeApplication(groupName, instanceName, applicationName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return (Application)response.getEntity(Application.class);
        }
        throw this.convertClientResponseToException("describeApplication", response);
    }

    @Override
    public List<Application> listApplications(String groupName, String instanceName) {
        ClientResponse response = this.getPublicManagerHelper().listApplications(groupName, instanceName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Applications)response.getEntity(Applications.class)).getApplications();
        }
        throw this.convertClientResponseToException("listApplications", response);
    }

    @Override
    public Job stopApplication(String groupName, String instanceName, String applicationName) {
        return this.stopApplication(groupName, instanceName, applicationName, ApplicationState.STATE_PREPARED);
    }

    @Override
    public Job stopApplication(String groupName, String instanceName, String applicationName, ApplicationState targetState) {
        ClientResponse response = this.getPublicManagerHelper().stopApplication(groupName, instanceName, applicationName, targetState);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("stopApplication", response);
    }

    @Override
    public Job startApplication(String groupName, String instanceName, String applicationName) {
        return this.startApplication(groupName, instanceName, applicationName, ApplicationState.STATE_ACTIVE);
    }

    @Override
    public Job startApplication(String groupName, String instanceName, String applicationName, ApplicationState targetState) {
        ClientResponse response = this.getPublicManagerHelper().startApplication(groupName, instanceName, applicationName, targetState);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("startApplication", response);
    }

    @Override
    public List<WebModuleInstance> listWebModuleInstances(String groupName, String instanceName, String applicationName) {
        ClientResponse response = this.getPublicManagerHelper().listWebModuleInstances(groupName, instanceName, applicationName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((WebModuleInstances)response.getEntity(WebModuleInstances.class)).getInstances();
        }
        throw this.convertClientResponseToException("listWebModuleInstances", response);
    }

    @Override
    public List<WebModuleInstance> listWebModuleInstances(String groupName, String instanceName, String applicationName, String moduleURI) {
        ClientResponse response = this.getPublicManagerHelper().listWebModuleInstances(groupName, instanceName, applicationName, moduleURI);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((WebModuleInstances)response.getEntity(WebModuleInstances.class)).getInstances();
        }
        throw this.convertClientResponseToException("listWebModuleInstances", response);
    }

    @Override
    public List<WorkManagerInstance> listWorkManagerInstances(String groupName, String instanceName, String applicationName) {
        ClientResponse response = this.getPublicManagerHelper().listWorkManagerInstances(groupName, instanceName, applicationName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((WorkManagerInstances)response.getEntity(WorkManagerInstances.class)).getInstances();
        }
        throw this.convertClientResponseToException("listWorkManagerInstances", response);
    }

    @Override
    public List<WorkManagerInstance> listWorkManagerInstances(String groupName, String instanceName, String applicationName, String workManagerName) {
        ClientResponse response = this.getPublicManagerHelper().listWorkManagerInstances(groupName, instanceName, applicationName, workManagerName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((WorkManagerInstances)response.getEntity(WorkManagerInstances.class)).getInstances();
        }
        throw this.convertClientResponseToException("listWorkManagerInstances", response);
    }

    @Override
    public List<Metric> queryServiceInstanceMetrics(String groupName, String instanceName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryServiceInstanceMetrics(groupName, instanceName, groupBy, false);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryServiceInstanceMetrics", response);
    }

    @Override
    public List<Metric> queryServiceInstanceMetricsWithMetadata(String groupName, String instanceName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryServiceInstanceMetrics(groupName, instanceName, groupBy, true);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryServiceInstanceMetricsWithMetadata", response);
    }

    @Override
    public List<Metric> queryServiceInstanceMetrics(String groupName, String instanceName, String metricName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryServiceInstanceMetrics(groupName, instanceName, metricName, groupBy, false);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryServiceInstanceMetrics", response);
    }

    @Override
    public List<Metric> queryServiceInstanceMetricsWithMetadata(String groupName, String instanceName, String metricName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryServiceInstanceMetrics(groupName, instanceName, metricName, groupBy, true);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryServiceInstanceMetricsWithMetadata", response);
    }

    @Override
    public List<Metric> queryApplicationMetrics(String groupName, String instanceName, String applicationName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryApplicationMetrics(groupName, instanceName, applicationName, groupBy, false);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryApplicationMetrics", response);
    }

    @Override
    public List<Metric> queryApplicationMetricsWithMetadata(String groupName, String instanceName, String applicationName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryApplicationMetrics(groupName, instanceName, applicationName, groupBy, true);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryApplicationMetricsWithMetadata", response);
    }

    @Override
    public List<Metric> queryApplicationMetrics(String groupName, String instanceName, String applicationName, String metricName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryApplicationMetrics(groupName, instanceName, applicationName, metricName, groupBy, false);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryApplicationMetrics", response);
    }

    @Override
    public List<Metric> queryApplicationMetricsWithMetadata(String groupName, String instanceName, String applicationName, String metricName, String groupBy) {
        ClientResponse response = this.getPublicManagerHelper().queryApplicationMetrics(groupName, instanceName, applicationName, metricName, groupBy, true);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Metrics)response.getEntity(Metrics.class)).getMetrics();
        }
        throw this.convertClientResponseToException("queryApplicationMetricsWithMetadata", response);
    }

    @Override
    public void release() {
        if (this.getClient() != null) {
            this.getClient().destroy();
            this.setClient(null);
        }
    }

    @Override
    public Job restartService(String identityDomain, String serviceName, boolean forceRestart, long serverRestartTimeout) {
        ClientResponse response = this.getPublicManagerHelper().restartService(identityDomain, serviceName, forceRestart, serverRestartTimeout);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("restartService", response);
    }

    @Override
    public Job restartService(String identityDomain, String serviceName, boolean forceRestart) {
        ClientResponse response = this.getPublicManagerHelper().restartService(identityDomain, serviceName, forceRestart, null);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("restartService", response);
    }
}

