/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import oracle.cloud.paas.api.ServiceInstanceLogCriteria;
import oracle.cloud.paas.exception.AuthenticationException;
import oracle.cloud.paas.exception.ConnectionException;
import oracle.cloud.paas.exception.DuplicateResourceException;
import oracle.cloud.paas.exception.InvalidDescriptorException;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.exception.ResourceBusyException;
import oracle.cloud.paas.exception.ResourcePermissionException;
import oracle.cloud.paas.exception.UnknownResourceException;
import oracle.cloud.paas.internal.Helper;
import oracle.cloud.paas.internal.PublicManagerHelper;
import oracle.cloud.paas.internal.RequestIdFilter;
import oracle.cloud.paas.internal.SAMLTokenAuthFilter;
import oracle.cloud.paas.internal.ServiceInstanceLogCriteriaImpl;
import oracle.cloud.paas.internal.TrustTokenProvider;
import oracle.cloud.paas.model.ExceptionWrapper;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.Log;
import oracle.cloud.paas.model.Logs;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.nls.MessageBundleUtil;

public abstract class AbstractManagerImpl {
    protected static Logger logger = Logger.getLogger("oracle.cloud.paas");
    protected static final String PATH_GROUP_NAME = "groupName";
    protected static final String PATH_INSTANCE_NAME = "instanceName";
    protected static final String PATH_APPLICATION_NAME = "applicationName";
    protected static final String PATH_LIBRARY_NAME = "libraryName";
    protected static final String PATH_JOB_ID = "jobID";
    protected static final String PATH_LOG_NAME = "logName";
    protected static final String PATH_DATA_SOURCE_NAME = "dataSourceName";
    protected static final String PATH_SERVER_NAME = "serverName";
    protected static final String PATH_ASSOCIATION_NAME = "associationName";
    protected static final String PATH_METRIC_NAME = "metricName";
    protected static final String PATH_ALERT_ID = "alertId";
    private static final int DEFAULT_CLIENT_CONNECT_TIMEOUT = 120000;
    private static final int DEFAULT_CLIENT_READ_TIMEOUT = 120000;
    private Client client = null;
    private final URL url;
    private final String user;
    private final String identityDomain;
    private final String serviceUrl;
    private String requestId;
    protected boolean simv1 = false;

    private AbstractManagerImpl(URL url, String identityDomain, String user, Map<String, Object> clientProperties) {
        this.url = url;
        if (identityDomain == null && user != null) {
            int index = user.indexOf(".");
            if (index > 0) {
                this.identityDomain = user.substring(0, index);
                this.user = user.substring(index + 1);
            } else {
                this.identityDomain = "CloudInfra";
                this.user = user;
            }
        } else {
            this.identityDomain = identityDomain;
            this.user = user;
        }
        this.serviceUrl = url.getPort() != -1 ? url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() : url.getProtocol() + "://" + url.getHost();
        this.client = Client.create();
        this.client.addFilter((ClientFilter)new RequestIdFilter(this));
        this.client.setChunkedEncodingSize(Integer.valueOf(32768));
        this.configureClient(clientProperties);
    }

    public AbstractManagerImpl(URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        this(url, identityDomain, user, clientProperties);
        if (user == null) {
            return;
        }
        ClientFilter authenticationFilter = this.buildClientAuthenticationFilter(this.user, password);
        this.client.addFilter(authenticationFilter);
        WebResource resource = this.client.resource(UriBuilder.fromPath((String)this.getServiceUrl()).path("/paas-version").build(new Object[0]));
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            String tenantPrefixeduser = identityDomain == null ? user : identityDomain + "." + user;
            this.client.removeFilter(authenticationFilter);
            this.client.addFilter(this.buildClientAuthenticationFilter(tenantPrefixeduser, password));
            WebResource resource2 = this.client.resource(UriBuilder.fromPath((String)this.getServiceUrl()).path("/domain/" + identityDomain).build(new Object[0]));
            response = (ClientResponse)resource2.accept(new String[]{"application/xml"}).get(ClientResponse.class);
            if (this.isFailedAuthentication(response)) {
                throw this.getAuthException();
            }
            this.simv1 = true;
        }
    }

    public AbstractManagerImpl(URL url, String identityDomain, String user, TrustTokenProvider provider, Map<String, Object> clientProperties) {
        this(url, identityDomain, user, clientProperties);
        try {
            this.client.addFilter((ClientFilter)new SAMLTokenAuthFilter(this.user, provider));
        }
        catch (Throwable e) {
            throw new ManagerException("Error setting up trust token provier", e);
        }
    }

    private AuthenticationException getAuthException() {
        return new AuthenticationException("Unknown user name or password");
    }

    private ClientFilter buildClientAuthenticationFilter(String user, String password) {
        SAMLTokenAuthFilter authenticationFilter = password == null ? new SAMLTokenAuthFilter(user, null) : new HTTPBasicAuthFilter(user, password);
        return authenticationFilter;
    }

    public Client getClient() {
        return this.client;
    }

    protected void setClient(Client client) {
        this.client = client;
    }

    protected URL getUrl() {
        return this.url;
    }

    protected String getUser() {
        return this.user;
    }

    protected String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getIdentityDomain() {
        return this.identityDomain;
    }

    protected String getJobBaseUri() {
        if (this.simv1) {
            return "/job";
        }
        return "/paas-job/v13.2";
    }

    protected String getPaasJavaUri() {
        if (this.simv1) {
            return "/domain";
        }
        return "/paas/java/v13.2";
    }

    private String getDomainUri() {
        return this.getPaasJavaUri() + "/{groupName}";
    }

    private String getInstanceUri() {
        if (this.simv1) {
            return this.getDomainUri() + "/service/{instanceName}";
        }
        return this.getDomainUri() + "/{instanceName}";
    }

    private String getApplicationBaseUri() {
        return this.getInstanceUri() + "/" + "application";
    }

    private String getLibraryBaseUri() {
        return this.getInstanceUri() + "/" + "library";
    }

    private String getRestsartServiceUri() {
        return this.getInstanceUri() + "/" + "cluster";
    }

    private String getApplicationUri() {
        return this.getApplicationBaseUri() + "/{applicationName}";
    }

    private String getLibraryUri() {
        return this.getLibraryBaseUri() + "/{libraryName}";
    }

    private String getWorkManagerBaseUri() {
        return this.getApplicationUri() + "/" + "workmanager";
    }

    private String getInstanceMetricBaseUri() {
        return this.getInstanceUri() + "/" + "metric";
    }

    private String getApplicationMetricBaseUri() {
        return this.getApplicationUri() + "/" + "metric";
    }

    protected ManagerException convertClientResponseToException(String operation, ClientResponse response) {
        ClientResponse.Status status = response.getClientResponseStatus();
        if (this.isFailedAuthentication(response)) {
            return this.getAuthException();
        }
        if (status == ClientResponse.Status.BAD_GATEWAY) {
            return new ConnectionException("Invalid service URL: " + this.getServiceUrl().toString());
        }
        return this.convertRequestException(response);
    }

    private boolean isFailedAuthentication(ClientResponse response) {
        ClientResponse.Status status = response.getClientResponseStatus();
        return status == ClientResponse.Status.UNAUTHORIZED || response.getType() == null && status == ClientResponse.Status.FORBIDDEN;
    }

    private ManagerException convertRequestException(ClientResponse response) {
        ClientResponse.Status status = response.getClientResponseStatus();
        if (response.getType() != null && response.getType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            ExceptionWrapper e = (ExceptionWrapper)response.getEntity(ExceptionWrapper.class);
            if (status == ClientResponse.Status.NOT_FOUND) {
                return new UnknownResourceException(e.getMessage());
            }
            if (e.getType().equals("NQ-1000")) {
                return new InvalidDescriptorException(e.getMessage());
            }
            if (e.getType().equals("NQ-1001")) {
                return new DuplicateResourceException(e.getMessage());
            }
            if (e.getType().equals("NQ-1004")) {
                return new ResourcePermissionException(e.getMessage());
            }
            if (e.getType().equals("NQ-1002")) {
                Job job = null;
                String[] strs = e.getMessage().split(Helper.getActiveJobIDKeyMessage());
                if (strs.length == 2) {
                    String jobID = strs[1].trim();
                    ClientResponse jobResponse = this.getPublicManagerHelper().describeJob(jobID);
                    if (jobResponse.getClientResponseStatus() == ClientResponse.Status.OK) {
                        job = (Job)jobResponse.getEntity(Job.class);
                    }
                }
                return ResourceBusyException.createActiveJobException(e.getMessage(), job);
            }
            return new ManagerException(e.getType(), e.getMessage());
        }
        if (status == ClientResponse.Status.NOT_FOUND) {
            return new ConnectionException("Invalid service URL: " + this.getServiceUrl().toString());
        }
        String message = response.toString() + "\n" + (String)response.getEntity(String.class);
        return new ManagerException(message);
    }

    protected void assertPathParameter(String name, String value) {
        this.assertPathParameter(name, value, false);
    }

    protected void assertPathParameter(String name, String value, boolean isForwardSlashAllowed) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid " + name + " value: null");
        }
        if (value.equals("") || value.matches("\\s+")) {
            throw new IllegalArgumentException("Invalid " + name + " value: \"" + value + "\"");
        }
        if (!isForwardSlashAllowed && value.indexOf("/") != -1) {
            throw new IllegalArgumentException("Invalid " + name + " value: \"" + value + "\"." + " Forward slashes are not allowed.");
        }
    }

    protected WebResource createJobResource(String jobID) {
        String path = this.getJobBaseUri() + "/{jobID}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{jobID}));
    }

    public InputStream queryServiceInstanceLogs(String groupName, String instanceName, ServiceInstanceLogCriteria criteria) {
        ClientResponse response;
        Map<String, List<String>> queryParams = null;
        if (criteria != null) {
            queryParams = ((ServiceInstanceLogCriteriaImpl)criteria).getMap();
        }
        if ((response = this.getPublicManagerHelper().queryServiceInstanceLogs(groupName, instanceName, queryParams)).getClientResponseStatus() == ClientResponse.Status.OK) {
            try {
                return response.getEntityInputStream();
            }
            catch (Exception e) {
                throw new ManagerException(MessageBundleUtil.msg.getString("OC-PAAS-10047", e.getMessage()), e);
            }
        }
        throw this.convertClientResponseToException("executeLogQuery", response);
    }

    public List<Log> listServiceInstanceLogs(String groupName, String instanceName) {
        ClientResponse response = this.getPublicManagerHelper().listServiceInstanceLogs(groupName, instanceName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            return ((Logs)response.getEntity(Logs.class)).getLogs();
        }
        throw this.convertClientResponseToException("listServiceInstanceLogs", response);
    }

    public void fetchServiceInstanceLog(String groupName, String instanceName, String logName, OutputStream out) {
        ClientResponse response = this.getPublicManagerHelper().fetchServiceInstanceLog(groupName, instanceName, logName);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            try {
                byte[] log = ((String)response.getEntity(String.class)).getBytes();
                out.write(log, 0, log.length);
            }
            catch (Exception e) {
                throw new ManagerException(MessageBundleUtil.msg.getString("OC-PAAS-10007", e.getMessage()), e);
            }
        } else {
            throw this.convertClientResponseToException("fetchServiceInstanceLog", response);
        }
    }

    protected WebResource createJobPropertyResource(String jobID, String property) {
        String path = this.getJobBaseUri() + "/{jobID}/{property}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{jobID, property}));
    }

    protected WebResource createJobResource() {
        String path = this.getJobBaseUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[0]));
    }

    protected PublicManagerHelper getPublicManagerHelper() {
        return new PublicManagerHelper(this);
    }

    protected WebResource createJobLogResource(String jobID) {
        String path = this.getJobBaseUri() + "/{jobID}/" + "log";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{jobID}));
    }

    protected WebResource createJobLogResource(String jobID, String logName) {
        String path = this.getJobBaseUri() + "/{jobID}/" + "log" + "/{logName}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{jobID, logName}));
    }

    protected WebResource createDomainResource(String groupName) {
        String path = this.getDomainUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName}));
    }

    protected WebResource createInstanceResource(String groupName) {
        String path = this.getDomainUri();
        if (this.simv1) {
            path = path + "/service";
        }
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName}));
    }

    protected WebResource createInstanceResource(String groupName, String instanceName) {
        String path = this.getInstanceUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName}));
    }

    protected WebResource createApplicationResource(String groupName, String instanceName) {
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(this.getApplicationBaseUri()).build(new Object[]{groupName, instanceName}));
    }

    protected WebResource createApplicationResource(String groupName, String instanceName, String applicationName) {
        String path = this.getApplicationUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName}));
    }

    public WebResource createRestartServiceResource(String identityDomain, String serviceName) {
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(this.getRestsartServiceUri()).build(new Object[]{identityDomain, serviceName}));
    }

    protected WebResource createApplicationPropertyResource(String groupName, String instanceName, String applicationName, String property) {
        String path = this.getApplicationUri() + "/{property}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName, property}));
    }

    protected WebResource createServerResource(String groupName, String instanceName) {
        String path = this.getInstanceUri() + "/" + "server";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName}));
    }

    protected WebResource createServerResource(String groupName, String instanceName, String serverName) {
        String path = this.getInstanceUri() + "/" + "server" + "/{serverName}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, serverName}));
    }

    protected WebResource createDatasourceResource(String groupName, String instanceName) {
        String path = this.getInstanceUri() + "/" + "datasource";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName}));
    }

    protected WebResource createDatasourceResource(String groupName, String instanceName, String datasource) {
        String path = this.getInstanceUri() + "/" + "datasource" + "/{datasource}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, datasource}));
    }

    protected WebResource createApplicationStateChangeResource(String groupName, String instanceName, String applicationName) {
        if (!this.simv1) {
            return this.createApplicationResource(groupName, instanceName, applicationName);
        }
        String path = this.getApplicationUri() + "/" + "state";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName}));
    }

    protected WebResource createInstanceLogResource(String groupName, String instanceName) {
        String path = this.getInstanceUri() + "/" + "log";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName}));
    }

    protected WebResource createInstanceLogResource(String groupName, String instanceName, String logName) {
        String path = this.getInstanceUri() + "/" + "log" + "/{logName}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, logName}));
    }

    protected WebResource createLibraryResource(String domainName, String instanceName) {
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(this.getLibraryBaseUri()).build(new Object[]{domainName, instanceName}));
    }

    protected WebResource createLibraryResource(String domainName, String instanceName, String libraryName) {
        String path = this.getLibraryUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{domainName, instanceName, libraryName}));
    }

    protected WebResource createLibraryRefrencesResource(String domainName, String instanceName, String libraryName) {
        String path = this.getLibraryUri() + "/" + "references";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{domainName, instanceName, libraryName}));
    }

    protected WebResource createWebModuleResource(String groupName, String instanceName, String applicationName) {
        String path = this.getApplicationUri() + "/" + "webmodule";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName}));
    }

    protected WebResource createWebModuleResource(String groupName, String instanceName, String applicationName, String moduleURI) {
        String path = this.getApplicationUri() + "/" + "webmodule" + "/{moduleURI}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName, moduleURI}));
    }

    protected WebResource createWorkManagerResource(String groupName, String instanceName, String applicationName) {
        String path = this.getWorkManagerBaseUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName}));
    }

    protected WebResource createWorkManagerResource(String groupName, String instanceName, String applicationName, String workManagerName) {
        String path = this.getWorkManagerBaseUri() + "/{workManagerName}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName, workManagerName}));
    }

    protected WebResource createInstanceMetricResource(String groupName, String instanceName) {
        String path = this.getInstanceMetricBaseUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName}));
    }

    protected WebResource createInstanceMetricResource(String groupName, String instanceName, String metricName) {
        String path = this.getInstanceMetricBaseUri() + "/{metricName}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, metricName}));
    }

    protected WebResource createApplicationMetricResource(String groupName, String instanceName, String applicationName) {
        String path = this.getApplicationMetricBaseUri();
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName}));
    }

    protected WebResource createApplicationMetricResource(String groupName, String instanceName, String applicationName, String metricName) {
        String path = this.getApplicationMetricBaseUri() + "/{metricName}";
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).path(path).build(new Object[]{groupName, instanceName, applicationName, metricName}));
    }

    protected WebResource createWelcomePageResource() {
        return this.getClient().resource(UriBuilder.fromPath((String)this.getServiceUrl()).build(new Object[0]));
    }

    protected Job updateServiceInstance(String groupName, String instanceName, ServiceInstance platformDeployment) {
        WebResource resource = this.createInstanceResource(groupName, instanceName);
        logger.fine("updateServiceInstance REST URI: " + resource.getURI());
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml", "text/plain"})).put(ClientResponse.class, (Object)platformDeployment);
        if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
            return (Job)response.getEntity(Job.class);
        }
        throw this.convertClientResponseToException("updateServiceInstance", response);
    }

    private void configureClient(Map<String, Object> clientProperties) {
        this.client.setConnectTimeout(Integer.valueOf(120000));
        this.client.setReadTimeout(Integer.valueOf(120000));
        if (clientProperties != null) {
            Object connectTimeout = clientProperties.get("oracle.cloud.paas.api.client.connect.timeout");
            if (connectTimeout != null && connectTimeout instanceof Integer && (Integer)connectTimeout >= 0) {
                this.client.setConnectTimeout((Integer)connectTimeout);
            } else if (connectTimeout == null && clientProperties.containsKey("oracle.cloud.paas.api.client.connect.timeout")) {
                this.client.setConnectTimeout(null);
            }
            Object readTimeout = clientProperties.get("oracle.cloud.paas.api.client.read.timeout");
            if (readTimeout != null && readTimeout instanceof Integer && (Integer)readTimeout >= 0) {
                this.client.setReadTimeout((Integer)readTimeout);
            } else if (readTimeout == null && clientProperties.containsKey("oracle.cloud.paas.api.client.read.timeout")) {
                this.client.setReadTimeout(null);
            }
        }
    }
}

