/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.exception;

import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.internal.Helper;
import oracle.cloud.paas.model.Job;

public class ResourceBusyException
extends ManagerException {
    private static final long serialVersionUID = 1L;
    private Job activeJob;

    public ResourceBusyException(String message) {
        super("NQ-1002", message);
    }

    public Job getActiveJob() {
        return this.activeJob;
    }

    public static ResourceBusyException createActiveJobException(String message, Job job) {
        String activeJobMsg;
        String string = activeJobMsg = message == null ? "Resource unavailable because of active operation '" + job.getOperation() + "'." : message;
        if (job != null && !activeJobMsg.endsWith(Helper.getActiveJobIDKeyMessage() + job.getJobId())) {
            activeJobMsg = activeJobMsg + " " + Helper.getActiveJobIDKeyMessage() + job.getJobId();
        }
        ResourceBusyException ex = new ResourceBusyException(activeJobMsg);
        ex.activeJob = job;
        return ex;
    }

    public static ResourceBusyException createActiveJobException(Job job) {
        return ResourceBusyException.createActiveJobException(null, job);
    }
}

