/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.api;

import java.net.URL;
import java.util.Map;
import java.util.ServiceLoader;
import oracle.cloud.paas.api.Connection;
import oracle.cloud.paas.spi.ConnectionServiceProvider;

public class ConnectionFactory {
    public static Connection createConnection(URL url, String user, String password) {
        return ConnectionFactory.createConnection(url, null, user, password);
    }

    public static Connection createConnection(URL url, String identityDomain, String user, String password) {
        return ConnectionFactory.createConnection("cloud", url, identityDomain, user, password, null);
    }

    public static Connection createConnection(URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        return ConnectionFactory.createConnection("cloud", url, identityDomain, user, password, clientProperties);
    }

    public static Connection createConnection(String provider, URL url, String user, String password) {
        return ConnectionFactory.createConnection(url, null, user, password);
    }

    public static Connection createConnection(String provider, URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        ServiceLoader<ConnectionServiceProvider> loader = ServiceLoader.load(ConnectionServiceProvider.class);
        Connection connection = ConnectionFactory.getConnectionFromServiceLoader(loader, provider, url, identityDomain, user, password, clientProperties);
        if (connection == null) {
            loader = ServiceLoader.load(ConnectionServiceProvider.class, ConnectionFactory.class.getClassLoader());
            connection = ConnectionFactory.getConnectionFromServiceLoader(loader, provider, url, identityDomain, user, password, clientProperties);
        }
        return connection;
    }

    private static Connection getConnectionFromServiceLoader(ServiceLoader<ConnectionServiceProvider> loader, String provider, URL url, String identityDomain, String user, String password, Map<String, Object> clientProperties) {
        if (loader == null) {
            return null;
        }
        for (ConnectionServiceProvider impl : loader) {
            if (!impl.getName().equals(provider)) continue;
            return impl.createConnection(url, identityDomain, user, password, clientProperties);
        }
        return null;
    }
}

