/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class PossibleValuesValidationService
extends ValidationService {
    private PossibleValuesService possibleValuesService;
    private Listener possibleValuesServiceListener;

    @Override
    protected void initValidationService() {
        this.possibleValuesService = this.context(Property.class).service(PossibleValuesService.class);
        if (this.possibleValuesService != null) {
            this.possibleValuesServiceListener = new Listener(){

                @Override
                public void handle(Event event) {
                    PossibleValuesValidationService.this.refresh();
                }
            };
            this.possibleValuesService.attach(this.possibleValuesServiceListener);
        }
    }

    @Override
    protected Status compute() {
        Status.Severity severity;
        ValueProperty property;
        Element element = this.context(Element.class);
        Value value = element.property(property = this.context(ValueProperty.class));
        String valueString = value.text(true);
        if (valueString != null && this.possibleValuesService != null && !this.possibleValuesService.values().contains(valueString) && (severity = this.possibleValuesService.getInvalidValueSeverity(valueString)) != Status.Severity.OK) {
            String message = this.possibleValuesService.getInvalidValueMessage(valueString);
            return Status.createStatus(severity, message);
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.possibleValuesServiceListener != null) {
            this.possibleValuesService.detach(this.possibleValuesServiceListener);
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            return property != null && property.definition() instanceof ValueProperty && property.service(PossibleValuesService.class) != null && property.service(ReferenceService.class) == null;
        }
    }
}

