/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class MalformedValueValidationService
extends ValidationService {
    @Text(value="\"{1}\" is not a valid {0}")
    private static LocalizableText cannotParseValueMessage;
    private String valueTypeName;

    static {
        LocalizableText.init(MalformedValueValidationService.class);
    }

    @Override
    protected Status compute() {
        Value value = this.context(Element.class).property(this.context(ValueProperty.class));
        if (value.malformed()) {
            if (this.valueTypeName == null) {
                Class<?> type = value.definition().getTypeClass();
                this.valueTypeName = LocalizationSystem.service(type).label(type, CapitalizationType.NO_CAPS, false);
            }
            String msg = cannotParseValueMessage.format(this.valueTypeName, value.text());
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && !String.class.isAssignableFrom(property.getTypeClass());
        }
    }
}

