/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValueImageService;

public final class EnumValueImageService
extends ValueImageService {
    private EnumValueType enumType;
    private final Map<Enum<?>, ImageData> images = new HashMap();

    @Override
    protected void init() {
        super.init();
        this.enumType = new EnumValueType(this.context(ValueProperty.class).getTypeClass());
    }

    @Override
    public ImageData provide(String value) {
        Image imageAnnotation;
        MasterConversionService masterConversionService = this.context(ValueProperty.class).service(MasterConversionService.class);
        Enum<?> item = masterConversionService.convert(value, this.enumType.getEnumTypeClass());
        if (item == null) {
            return null;
        }
        ImageData image = this.images.get(item);
        if (image == null && (imageAnnotation = this.enumType.getAnnotation(item, Image.class)) != null && (image = ImageData.readFromClassLoader(this.enumType.getEnumTypeClass(), imageAnnotation.path()).optional()) != null) {
            this.images.put(item, image);
        }
        return image;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && Enum.class.isAssignableFrom(property.getTypeClass());
        }
    }
}

