/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class CountConstraintValidationService
extends ValidationService {
    @Text(value="At least {1} {0} must be specified")
    private static LocalizableText countConstraintTooFew;
    @Text(value="At least one {0} must be specified")
    private static LocalizableText countConstraintTooFewAtLeastOne;
    @Text(value="Cannot specify more than {1} {0} items")
    private static LocalizableText countConstraintTooMany;
    private CountConstraint constraint;

    static {
        LocalizableText.init(CountConstraintValidationService.class);
    }

    @Override
    protected void initValidationService() {
        this.constraint = this.context(PropertyDef.class).getAnnotation(CountConstraint.class);
    }

    @Override
    protected Status compute() {
        ElementList list = this.context(ElementList.class);
        int count = list.size();
        String message = null;
        if (count < this.constraint.min()) {
            message = this.constraint.min() == 1 ? countConstraintTooFewAtLeastOne.format(this.context(PropertyDef.class).getType().getLabel(true, CapitalizationType.NO_CAPS, false)) : countConstraintTooFew.format(this.context(PropertyDef.class).getType().getLabel(true, CapitalizationType.NO_CAPS, false), this.constraint.min());
        } else if (count > this.constraint.max()) {
            message = countConstraintTooMany.format(this.context(PropertyDef.class).getType().getLabel(true, CapitalizationType.NO_CAPS, false), this.constraint.max());
        }
        if (message == null) {
            return Status.createOkStatus();
        }
        return Status.createErrorStatus(message);
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ListProperty property = context.find(ListProperty.class);
            return property != null && property.hasAnnotation(CountConstraint.class);
        }
    }
}

