/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public abstract class PropertyFunction<P extends Property>
extends Function {
    @Override
    public final FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){
            private P property;
            private Listener listener;

            @Override
            protected Object evaluate() {
                Property p = null;
                try {
                    p = (Property)this.operand(0, PropertyFunction.this.findPropertyType(), false);
                }
                catch (Throwable throwable) {
                    if (this.property != p) {
                        if (this.property != null && this.listener != null) {
                            ((Property)this.property).detach(this.listener);
                        }
                        this.property = p;
                        if (this.property != null) {
                            if (this.listener == null) {
                                this.listener = new Listener(){

                                    @Override
                                    public void handle(Event event) {
                                        if (event instanceof PropertyEvent && PropertyFunction.this.relevant((PropertyEvent)event)) {
                                            this.refresh();
                                        }
                                    }
                                };
                            }
                            ((Property)this.property).attach(this.listener);
                        }
                    }
                    throw throwable;
                }
                if (this.property != p) {
                    if (this.property != null && this.listener != null) {
                        ((Property)this.property).detach(this.listener);
                    }
                    this.property = p;
                    if (this.property != null) {
                        if (this.listener == null) {
                            this.listener = new /* invalid duplicate definition of identical inner class */;
                        }
                        ((Property)this.property).attach(this.listener);
                    }
                }
                return PropertyFunction.this.evaluate(this.property);
            }

            @Override
            public void dispose() {
                super.dispose();
                if (this.property != null) {
                    ((Property)this.property).detach(this.listener);
                    this.property = null;
                    this.listener = null;
                }
            }
        };
    }

    protected abstract Object evaluate(P var1);

    protected abstract boolean relevant(PropertyEvent var1);

    private Class<P> findPropertyType() {
        return this.findPropertyType(this.getClass());
    }

    private Class<P> findPropertyType(Class<?> cl) {
        Type superGenericType = cl.getGenericSuperclass();
        if (superGenericType instanceof ParameterizedType) {
            ParameterizedType superParameterizedType = (ParameterizedType)superGenericType;
            Class superRawType = (Class)superParameterizedType.getRawType();
            if (superRawType == PropertyFunction.class) {
                Type t = superParameterizedType.getActualTypeArguments()[0];
                if (t instanceof Class) {
                    return (Class)t;
                }
                if (t instanceof ParameterizedType) {
                    return (Class)((ParameterizedType)t).getRawType();
                }
                throw new IllegalStateException();
            }
            return this.findPropertyType(superRawType);
        }
        Class superRawType = (Class)superGenericType;
        if (superRawType == PropertyFunction.class) {
            throw new IllegalStateException("PropertyFunction must be parameterized.");
        }
        return this.findPropertyType(superRawType);
    }
}

