/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;
import org.eclipse.sapphire.services.PossibleTypesService;

public class ModelElementFunctionContext
extends FunctionContext {
    @Text(value="Index {0} is outside the bounds of the collection.")
    private static LocalizableText indexOutOfBounds;
    private final Element element;
    private final LocalizationService localizationService;

    static {
        LocalizableText.init(ModelElementFunctionContext.class);
    }

    public ModelElementFunctionContext(Element element) {
        this(element, SourceLanguageLocalizationService.INSTANCE);
    }

    public ModelElementFunctionContext(Element element, LocalizationService localizationService) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.localizationService = localizationService;
    }

    public final Element element() {
        return this.element;
    }

    @Override
    public FunctionResult property(Object element, final String name) {
        if (element == this && name.equalsIgnoreCase("This")) {
            Function f = new Function(){

                @Override
                public String name() {
                    return "This";
                }

                @Override
                public FunctionResult evaluate(FunctionContext context) {
                    return new FunctionResult(this, context){

                        @Override
                        protected Object evaluate() {
                            return ModelElementFunctionContext.this.element();
                        }
                    };
                }
            };
            f.init(new Function[0]);
            return f.evaluate(this);
        }
        if (element == this || element instanceof Element) {
            Element el = element == this ? this.element() : (Element)element;
            Property property = el.property(name);
            if (property != null) {
                ReadPropertyFunction f = new ReadPropertyFunction(property, name, PropertyContentEvent.class){

                    @Override
                    protected Object evaluate() {
                        return this.context;
                    }
                };
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
        } else if (element instanceof ElementHandle) {
            ElementHandle handle = (ElementHandle)element;
            ElementProperty elementPropertyDef = handle.definition();
            boolean ok = false;
            if (elementPropertyDef instanceof ImpliedElementProperty) {
                ok = elementPropertyDef.getType().property(name) != null;
            } else {
                for (ElementType possibleChildType : handle.service(PossibleTypesService.class).types()) {
                    boolean bl = ok = possibleChildType.property(name) != null;
                    if (ok) break;
                }
            }
            if (ok) {
                ReadPropertyFunction f = new ReadPropertyFunction(handle, name, PropertyContentEvent.class){

                    @Override
                    protected Object evaluate() {
                        Object child = ((ElementHandle)this.context).content();
                        if (child != null) {
                            return child.property(name);
                        }
                        return null;
                    }
                };
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
        } else if (element instanceof ElementList) {
            ElementList list = (ElementList)element;
            try {
                final int index = Integer.parseInt(name);
                ReadPropertyFunction f = new ReadPropertyFunction(list, name, PropertyContentEvent.class){

                    @Override
                    protected Object evaluate() {
                        ElementList list = (ElementList)this.context;
                        if (index >= 0 && index < list.size()) {
                            return list.get(index);
                        }
                        throw new FunctionException(indexOutOfBounds.format(index));
                    }
                };
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return super.property(element, name);
    }

    @Override
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    private static abstract class ReadPropertyFunction
    extends Function {
        protected final Property context;
        private final String name;
        private final Class<? extends PropertyEvent> eventType;

        public ReadPropertyFunction(Property context, String name, Class<? extends PropertyEvent> eventType) {
            this.context = context;
            this.name = name;
            this.eventType = eventType;
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final FunctionResult evaluate(FunctionContext context) {
            final Property property = this.context;
            final Class<? extends PropertyEvent> eventType = this.eventType;
            return new FunctionResult(this, context){
                private Listener listener;

                @Override
                protected void init() {
                    super.init();
                    this.listener = new Listener(){

                        @Override
                        public void handle(Event event) {
                            if (eventType.isInstance(event)) {
                                this.refresh();
                            }
                        }
                    };
                    property.attach(this.listener);
                }

                @Override
                protected Object evaluate() {
                    return ReadPropertyFunction.this.evaluate();
                }

                @Override
                public void dispose() {
                    super.dispose();
                    property.detach(this.listener);
                }
            };
        }

        protected abstract Object evaluate();
    }
}

