/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.sapphire.modeling.el.AggregateFunction;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class AvgFunction
extends AggregateFunction {
    @Override
    public String name() {
        return "Avg";
    }

    @Override
    public final FunctionResult evaluate(FunctionContext context) {
        return new AggregateFunction.AggregateFunctionResult(this, context){

            @Override
            protected Object evaluate(List<Object> items) {
                BigDecimal sum = null;
                int count = 0;
                for (Object item : items) {
                    if (item == null) continue;
                    BigDecimal itemAsDecimal = this.cast(item, BigDecimal.class);
                    sum = sum == null ? itemAsDecimal : sum.add(itemAsDecimal);
                    ++count;
                }
                if (count == 0) {
                    return new BigDecimal(0);
                }
                return sum.divide(new BigDecimal(count), 4);
            }
        };
    }
}

