/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.CollationService;
import org.eclipse.sapphire.Counter;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Index;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class UniqueValueValidationService
extends ValidationService {
    @Text(value="Unique {0} required. Another occurrence of \"{1}\" was found")
    private static LocalizableText message;
    private CollationService collationService;
    private Listener collationServiceListener;
    private Index<?> index;
    private Listener indexListener;

    static {
        LocalizableText.init(UniqueValueValidationService.class);
    }

    @Override
    protected void initValidationService() {
        Value value = this.context(Value.class);
        this.collationService = value.service(CollationService.class);
        this.collationServiceListener = new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Event event) {
                UniqueValueValidationService uniqueValueValidationService = UniqueValueValidationService.this;
                synchronized (uniqueValueValidationService) {
                    if (UniqueValueValidationService.this.index != null) {
                        UniqueValueValidationService.this.index.detach(UniqueValueValidationService.this.indexListener);
                        UniqueValueValidationService.this.index = null;
                    }
                }
                UniqueValueValidationService.this.refresh();
            }
        };
        this.collationService.attach(this.collationServiceListener);
        this.indexListener = new Listener(){

            @Override
            public void handle(Event event) {
                UniqueValueValidationService.this.refresh();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Status compute() {
        Index<?> index;
        Counter.increment(UniqueValueValidationService.class);
        Value value = this.context(Value.class);
        UniqueValueValidationService uniqueValueValidationService = this;
        synchronized (uniqueValueValidationService) {
            if (this.index == null) {
                ElementList list = (ElementList)value.element().parent();
                this.index = list.index(value.definition(), this.collationService.comparator());
                this.index.attach(this.indexListener);
            }
            index = this.index;
        }
        String text = value.text();
        if (text != null && index.elements(text).size() > 1) {
            String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
            String msg = message.format(label, text);
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        if (this.collationService != null) {
            this.collationService.detach(this.collationServiceListener);
            this.collationService = null;
            this.collationServiceListener = null;
        }
        if (this.index != null) {
            this.index.detach(this.indexListener);
            this.index = null;
        }
        this.indexListener = null;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            Element element = context.find(Element.class);
            return property != null && property.hasAnnotation(NoDuplicates.class) && element.parent() instanceof ElementList;
        }
    }
}

