/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.io.File;
import java.io.IOException;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;

public final class FileUtil {
    @Text(value="Failed to create directory \"{0}\".")
    private static LocalizableText failedToCreateDirectory;
    @Text(value="Location \"{0}\" is a file.")
    private static LocalizableText locationIsFile;

    static {
        LocalizableText.init(FileUtil.class);
    }

    public static void mkdirs(File f) throws IOException {
        if (f.exists()) {
            if (f.isFile()) {
                throw new IOException(locationIsFile.format(f.getAbsolutePath()));
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
            boolean isSuccessful = f.mkdir();
            if (!isSuccessful) {
                throw new IOException(failedToCreateDirectory.format(f.getAbsolutePath()));
            }
        }
    }
}

