/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm;

import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmAttributeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOxmAttributeMapping<A extends EJavaAttribute>
extends AbstractJaxbContextNode
implements OxmAttributeMapping<A> {
    protected A eJavaAttribute;

    protected AbstractOxmAttributeMapping(OxmJavaAttribute parent, A eJavaAttribute) {
        super((JaxbNode)parent);
        this.eJavaAttribute = eJavaAttribute;
    }

    public OxmJavaAttribute getPersistentAttribute() {
        return (OxmJavaAttribute)this.getParent();
    }

    public OxmJavaType getClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    public JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    @Override
    public A getEJavaAttribute() {
        return this.eJavaAttribute;
    }

    public String getBoundTypeName() {
        return this.getPersistentAttribute().getJavaResourceAttributeBaseTypeName();
    }

    public String getValueTypeName() {
        return this.getBoundTypeName();
    }

    public String getDataTypeName() {
        return this.getValueTypeName();
    }

    public XsdTypeDefinition getDataTypeXsdTypeDefinition() {
        JaxbTypeMapping jaxbTypeMapping;
        JaxbPackageInfo pkgInfo;
        String dataType = this.getDataTypeName();
        if (StringTools.isBlank((String)dataType)) {
            return null;
        }
        JaxbPackage pkg = this.getJaxbPackage();
        JaxbPackageInfo jaxbPackageInfo = pkgInfo = pkg == null ? null : pkg.getPackageInfo();
        if (pkgInfo != null) {
            for (XmlSchemaType schemaType : pkgInfo.getXmlSchemaTypes()) {
                if (!dataType.equals(schemaType.getFullyQualifiedType())) continue;
                return schemaType.getXsdTypeDefinition();
            }
        }
        if ((jaxbTypeMapping = this.getContextRoot().getTypeMapping(dataType)) != null) {
            return jaxbTypeMapping.getXsdTypeDefinition();
        }
        String builtInType = this.getJaxbProject().getPlatform().getDefinition().getSchemaTypeMapping(dataType);
        if (builtInType != null) {
            return XsdUtil.getSchemaForSchema().getTypeDefinition(builtInType);
        }
        return null;
    }

    public Iterable<String> getReferencedXmlTypeNames() {
        return new SingleElementIterable((Object)this.getValueTypeName());
    }

    public boolean isParticleMapping() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }
}

