/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.cloud.ICloudJob;
import oracle.eclipse.tools.cloud.ICloudServerJobsLogModel;
import oracle.eclipse.tools.cloud.job.CloudServerModelResource;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public final class JobLogDetailsFactory
extends FormComponentPart {
    private static final String PREF_EXPANDED_JOB_LOGS = "oracle.eclipse.tools.cloud.ui.server.job.log.expansion.state";
    private static Map<Composite, FormToolkit> toolkitCache = new HashMap<Composite, FormToolkit>();

    public FormComponentPresentation createPresentation(SwtPresentation parent, final Composite composite) {
        return new FormComponentPresentation(this, parent, composite){
            private ScrolledForm form;
            private Text text;
            private FormToolkit toolkit;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.form = null;
                this.text = null;
                this.toolkit = null;
            }

            public void render() {
                ICloudJob job = (ICloudJob)JobLogDetailsFactory.this.getModelElement();
                String jobId = (String)job.getId().content();
                ICloudServerJobsLogModel root = (ICloudServerJobsLogModel)job.nearest(ICloudServerJobsLogModel.class);
                CloudServerModelResource resource = (CloudServerModelResource)root.resource();
                IServer server = resource.server();
                composite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        toolkitCache.remove(composite);
                        toolkit.dispose();
                    }
                });
                this.toolkit = (FormToolkit)toolkitCache.get(composite);
                if (this.toolkit == null) {
                    this.toolkit = new FormToolkit(composite.getDisplay());
                    toolkitCache.put(composite, this.toolkit);
                }
                this.form = this.toolkit.createScrolledForm(composite);
                GridData gd = GridLayoutUtil.gdhspan((GridData)GridLayoutUtil.gdfill(), (int)2);
                gd.horizontalIndent = 10;
                gd.verticalAlignment = 128;
                gd.grabExcessVerticalSpace = true;
                this.form.setLayoutData((Object)gd);
                SwtUtil.reflowOnResize((Control)this.form);
                this.form.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent event) {
                        this.reflowForm();
                    }
                });
                this.form.getBody().setLayout(JobLogDetailsFactory.this.twlayout(1));
                this.form.setExpandVertical(true);
                this.text = new Text(this.form.getBody(), 0);
                this.text.setLayoutData(JobLogDetailsFactory.this.twd());
                this.refresh(server, jobId);
            }

            private void refresh(final IServer server, final String jobId) {
                this.text.setText("Loading job logs...");
                this.reflowForm();
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        OracleCloudServer wlsServer;
                        if (server != null && server.getServerState() != 4 && (wlsServer = (OracleCloudServer)server.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
                            try {
                                IRuntime rt = server.getRuntime();
                                OracleCloudRuntime crt = (OracleCloudRuntime)rt.loadAdapter(OracleCloudRuntime.class, null);
                                INuviaqDeployer deployer = crt.getNuviaqDeployer();
                                final Map logs = deployer.getJobLogs(jobId);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (form.isDisposed()) {
                                            return;
                                        }
                                        this.updateJobLogs(server, logs);
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                t.start();
            }

            private void updateJobLogs(IServer server, final Map<String, String> logs) {
                if (logs.keySet().size() == 0) {
                    this.text.setText("Selected job has no log");
                    this.reflowForm();
                    return;
                }
                this.text.setText("Expand the logs to see details");
                ExpansionAdapter expansionAdapter = new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        boolean expanded = e.getState();
                        ExpandableComposite expandableComposite = (ExpandableComposite)e.getSource();
                        String log = (String)expandableComposite.getData("name");
                        if (expanded) {
                            Control[] controlArray = expandableComposite.getChildren();
                            int n = controlArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control c = controlArray[n2];
                                if (c instanceof Text) {
                                    ((Text)c).setText((String)logs.get(log));
                                }
                                ++n2;
                            }
                        }
                        Set expandedLogs = this.getExpandedLogNames();
                        if (expanded) {
                            if (!expandedLogs.contains(log)) {
                                expandedLogs.add(log);
                                this.updateExpandedLogNames(expandedLogs);
                            }
                        } else if (expandedLogs.contains(log)) {
                            expandedLogs.remove(log);
                            this.updateExpandedLogNames(expandedLogs);
                        }
                        form.reflow(true);
                    }
                };
                for (String log : logs.keySet()) {
                    int style = 20;
                    boolean expanded = this.getExpandedLogNames().contains(log);
                    if (expanded) {
                        style |= 0x40;
                    }
                    ExpandableComposite expandableComposite = this.toolkit.createExpandableComposite(this.form.getBody(), style);
                    expandableComposite.clientVerticalSpacing = 5;
                    expandableComposite.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                    expandableComposite.setText(log);
                    expandableComposite.addExpansionListener((IExpansionListener)expansionAdapter);
                    expandableComposite.setLayoutData(JobLogDetailsFactory.this.twd());
                    expandableComposite.setLayout(JobLogDetailsFactory.this.twlayout(1));
                    expandableComposite.setText(log);
                    expandableComposite.setData("name", (Object)log);
                    style = 0x48 | this.toolkit.getOrientation() | 2;
                    Text formText = this.toolkit.createText((Composite)expandableComposite, "", style);
                    this.toolkit.adapt((Control)formText, true, true);
                    expandableComposite.setClient((Control)formText);
                    formText.setLayoutData(JobLogDetailsFactory.this.twd());
                    if (!expanded) continue;
                    formText.setText(logs.get(log));
                }
                this.reflowForm();
            }

            private void reflowForm() {
                GridData gd = (GridData)this.form.getLayoutData();
                gd.heightHint = this.form.getParent().getBounds().height - 10;
                this.form.reflow(true);
                this.form.getParent().layout(true, true);
            }

            private Set<String> getExpandedLogNames() {
                HashSet<String> ret = new HashSet<String>();
                String expansionState = CloudUiPlugin.preferences().getString(JobLogDetailsFactory.PREF_EXPANDED_JOB_LOGS);
                String[] stringArray = expansionState.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    ret.add(s);
                    ++n2;
                }
                return ret;
            }

            private void updateExpandedLogNames(Set<String> set) {
                StringBuilder expansionState = new StringBuilder();
                for (String s : set) {
                    expansionState.append(String.valueOf(s) + ";");
                }
                CloudUiPlugin.preferences().setValue(JobLogDetailsFactory.PREF_EXPANDED_JOB_LOGS, expansionState.toString());
            }
        };
    }

    protected Layout twlayout(int i) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = i;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        return layout;
    }

    private Object twd() {
        TableWrapData twd = new TableWrapData(256, 32);
        return twd;
    }
}

