/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.credential;

import java.util.Iterator;
import java.util.List;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.types.CertificateDescription;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import oracle.eclipse.tools.cloud.ui.server.internal.credential.CertificateDescriptions;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystoreEntry;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Display;

public class JcsKeystoreResource
extends Resource {
    public static final String FETCHING = "Fetching...";
    OracleCloudRuntime cloudRuntime = null;
    String name = null;
    String type = null;
    CertificateService certSvc = null;
    CertificateDescriptions certificateDescriptions = new CertificateDescriptions(this);

    public JcsKeystoreResource(String name, String type, OracleCloudRuntime cloudRuntime) {
        super(null);
        this.name = name;
        this.type = type;
        this.cloudRuntime = cloudRuntime;
    }

    public CertificateService getCertificateService() {
        return this.certSvc;
    }

    protected PropertyBinding createBinding(final Property property) {
        PropertyDef p = property.definition();
        if (p == IKeystore.PROP_PROVIDER) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JcsKeystoreResource.this.name;
                }

                public void write(String value) {
                }
            };
        }
        if (p == IKeystore.PROP_PASSWORD) {
            return new ValuePropertyBinding(){

                public String read() {
                    return "";
                }

                public void write(String value) {
                }
            };
        }
        if (p == IKeystore.PROP_PATH) {
            return new ValuePropertyBinding(){

                public String read() {
                    return "";
                }

                public void write(String value) {
                }
            };
        }
        if (p == IKeystore.PROP_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JcsKeystoreResource.this.type;
                }

                public void write(String value) {
                }
            };
        }
        if (p == IKeystore.PROP_KEYSTORE_ENTRIES) {
            LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){
                private FilteredListener<RemoteData.ContentEvent> fectcherListener = null;

                protected List<?> readUnderlyingList() {
                    if (this.fectcherListener == null) {
                        this.fectcherListener = new FilteredListener<RemoteData.ContentEvent>(){

                            protected void handleTypedEvent(RemoteData.ContentEvent event) {
                                final IKeystore modeElement = (IKeystore)property.element();
                                if (modeElement.disposed()) {
                                    return;
                                }
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((this).this).JcsKeystoreResource.this.certSvc = ((this).this).JcsKeystoreResource.this.certificateDescriptions.getCertificateService();
                                        modeElement.refresh();
                                    }
                                });
                            }
                        };
                    }
                    JcsKeystoreResource.this.certificateDescriptions.attach((Listener)this.fectcherListener);
                    if (JcsKeystoreResource.this.certificateDescriptions.available()) {
                        return (List)JcsKeystoreResource.this.certificateDescriptions.content();
                    }
                    JcsKeystoreResource.this.certificateDescriptions.fetch(true, null);
                    ListFactory ret = ListFactory.start();
                    ret.add((Object)FetchingRemoteDataNode.INSTANCE);
                    return ret.result();
                }

                protected Resource resource(Object obj) {
                    return new KeystoreEntryResource(JcsKeystoreResource.this, obj);
                }

                public ElementType type(Resource obj) {
                    return IKeystoreEntry.TYPE;
                }

                public void remove(Resource resource) {
                    KeystoreEntryResource res = (KeystoreEntryResource)resource;
                    IKeystoreEntry ke = (IKeystoreEntry)res.element();
                    String alias = (String)ke.getName().content();
                    Iterator it = ((List)JcsKeystoreResource.this.certificateDescriptions.content()).iterator();
                    while (it.hasNext()) {
                        CertificateDescription cd = (CertificateDescription)it.next();
                        if (!cd.getAlias().equals(alias)) continue;
                        it.remove();
                        break;
                    }
                }
            };
            return listBinding;
        }
        return null;
    }

    class KeystoreEntryResource
    extends Resource {
        boolean isFetching;
        CertificateDescription e;

        public KeystoreEntryResource(Resource parent, Object obj) {
            super(parent);
            this.isFetching = false;
            if (obj instanceof FetchingRemoteDataNode) {
                this.isFetching = true;
            } else {
                this.e = (CertificateDescription)obj;
            }
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef p = property.definition();
            if (p == IKeystoreEntry.PROP_NAME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        if (KeystoreEntryResource.this.isFetching) {
                            return JcsKeystoreResource.FETCHING;
                        }
                        return KeystoreEntryResource.this.e.getAlias();
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IKeystoreEntry.PROP_TYPE) {
                return new ValuePropertyBinding(){

                    public String read() {
                        if (KeystoreEntryResource.this.isFetching) {
                            return "";
                        }
                        return KeystoreEntryResource.this.e.getAlias();
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IKeystoreEntry.PROP_EXPIRY) {
                return new ValuePropertyBinding(){

                    public String read() {
                        if (KeystoreEntryResource.this.isFetching) {
                            return "";
                        }
                        return KeystoreEntryResource.this.e.getExpiry().toString();
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IKeystoreEntry.PROP_CERTIFICATE_CHAIN) {
                return new ValuePropertyBinding(){

                    public String read() {
                        if (KeystoreEntryResource.this.isFetching) {
                            return "";
                        }
                        return KeystoreEntryResource.this.e.getDn();
                    }

                    public void write(String value) {
                    }
                };
            }
            return null;
        }
    }
}

