/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.cnf.modules;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibrary;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.server.modules.JavaEEModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class ModulePropertyPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        IAdaptable adaptable = this.getElement();
        PublishedModule m = (PublishedModule)adaptable.getAdapter(PublishedModule.class);
        if (m instanceof CloudSharedLibrary) {
            this.setTitle("Shared Library");
            this.showShareLibProperties(comp, (CloudSharedLibrary)m);
        } else if (m instanceof JavaEEModule) {
            this.setTitle("Module");
            IServer server = m.server();
            IRuntime rt = server.getRuntime();
            this.showJavaEEModuleProperties(comp, m, rt);
        }
        return comp;
    }

    private void showJavaEEModuleProperties(Composite comp, PublishedModule m, IRuntime rt) {
        try {
            OracleCloudRuntime runtime = (OracleCloudRuntime)rt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            INuviaqDeployer deployer = runtime.getNuviaqDeployer();
            HashMap map = deployer.describeApplication(runtime.getTenantName(), runtime.getServiceName(), m.label());
            for (Object key : map.keySet()) {
                Label name = new Label(comp, 0);
                name.setText(String.valueOf(key.toString()) + ":");
                GridData gd = new GridData();
                gd.verticalAlignment = 1;
                name.setLayoutData((Object)gd);
                Object val = map.get(key);
                if (key.equals("URLs")) {
                    this.displayURLs(comp, val);
                    continue;
                }
                if (key.equals("Properties")) {
                    this.displayProperties(comp, val);
                    continue;
                }
                Label value = new Label(comp, 0);
                value.setText(val.toString());
            }
        }
        catch (CoreException coreException) {}
    }

    private void showShareLibProperties(Composite comp, CloudSharedLibrary lib) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("Name", lib.getName());
        props.put("Type", lib.getType());
        props.put("Specification Version", lib.getSpecVersion());
        props.put("Implementation Version", lib.getImplVersion());
        props.put("State", lib.getState());
        this.displayProperties(comp, props);
    }

    private void displayURLs(Composite comp, Object val) {
        Composite listComp = new Composite(comp, 0);
        listComp.setLayout((Layout)new GridLayout(1, true));
        List urls = (List)val;
        for (String url : urls) {
            Hyperlink link = new Hyperlink(listComp, 0);
            link.setText(url);
            link.setUnderlined(true);
            link.setForeground(SwtUtil.color((int)9));
            link.setHref((Object)url);
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    Object href = e.getHref();
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                        browser.openURL(new URL(href.toString()));
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            });
        }
    }

    private void displayProperties(Composite comp, Object val) {
        HashMap props = (HashMap)val;
        TableViewer viewer = new TableViewer(comp);
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 1;
        layoutData.horizontalAlignment = 1;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.heightHint = 200;
        layoutData.grabExcessVerticalSpace = true;
        viewer.getTable().setLayoutData((Object)layoutData);
        TableViewerColumn col = this.createTableViewerColumn(viewer, "Name", 150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String kv = element.toString();
                String[] vals = kv.split("=");
                return vals[0];
            }
        });
        col = this.createTableViewerColumn(viewer, "Value", 300);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String kv = element.toString();
                String[] vals = kv.split("=");
                return vals.length > 1 ? vals[1] : "";
            }
        });
        ArrayList<String> propList = new ArrayList<String>();
        for (String key : props.keySet()) {
            propList.add(String.valueOf(key) + "=" + (String)props.get(key));
        }
        viewer.getTable().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(propList);
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
    }
}

