/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.cnf.modules;

import java.util.List;
import oracle.eclipse.tools.cloud.CloudModules;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibraries;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibrary;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import oracle.eclipse.tools.weblogic.server.modules.JavaEEModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;

public class CloudModulesContentProvider
extends BaseContentProvider
implements ITreeContentProvider {
    private CommonViewer viewer;
    private Listener cloudModuleListener;
    private Listener cloudShareLibsListener;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IServer) {
            IServer server = (IServer)parentElement;
            if (server.getServerState() != 4) {
                OracleCloudRuntime crt = (OracleCloudRuntime)server.getRuntime().getAdapter(OracleCloudRuntime.class);
                OracleCloudServer wlsServer = (OracleCloudServer)server.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor());
                if (wlsServer != null) {
                    CloudModules cms = crt.getModules();
                    if (this.cloudModuleListener == null) {
                        this.cloudModuleListener = new FilteredListener<RemoteData.ContentEvent>(){

                            protected void handleTypedEvent(RemoteData.ContentEvent event) {
                                final IServer server = ((CloudModules)event.data()).server();
                                if (CloudModulesContentProvider.this.viewer.getControl().isDisposed()) {
                                    return;
                                }
                                CloudModulesContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        CloudModulesContentProvider.this.viewer.refresh((Object)server);
                                    }
                                });
                            }
                        };
                    }
                    cms.attach(this.cloudModuleListener);
                    if (!cms.available()) {
                        cms.fetch(true, null);
                        return new Object[]{crt.getSharedLibraries(), FetchingRemoteDataNode.INSTANCE};
                    }
                    List modules = (List)cms.content();
                    Object[] children = new Object[modules.size() + 1];
                    children[0] = crt.getSharedLibraries();
                    int i = 1;
                    int n = children.length;
                    while (i < n) {
                        children[i] = modules.get(i - 1);
                        ++i;
                    }
                    return children;
                }
            }
        } else if (parentElement instanceof CloudSharedLibraries) {
            CloudSharedLibraries sharedLibs = (CloudSharedLibraries)parentElement;
            if (this.cloudShareLibsListener == null) {
                this.cloudShareLibsListener = new FilteredListener<RemoteData.ContentEvent>(){

                    protected void handleTypedEvent(RemoteData.ContentEvent event) {
                        final CloudSharedLibraries libRoot = (CloudSharedLibraries)event.data();
                        CloudModulesContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CloudModulesContentProvider.this.viewer.refresh((Object)libRoot);
                            }
                        });
                    }
                };
            }
            sharedLibs.attach(this.cloudShareLibsListener);
            if (!sharedLibs.available()) {
                sharedLibs.fetch(true, null);
                return new Object[]{FetchingRemoteDataNode.INSTANCE};
            }
            Object[] children = ((List)sharedLibs.content()).toArray();
            return children;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof CloudSharedLibraries) {
            CloudSharedLibraries libRoot = (CloudSharedLibraries)element;
            return libRoot.server();
        }
        if (element instanceof CloudSharedLibrary) {
            CloudSharedLibrary lib = (CloudSharedLibrary)element;
            return lib.libraries();
        }
        if (element instanceof JavaEEModule) {
            PublishedModule m = (PublishedModule)element;
            return m.server();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IServer) {
            return true;
        }
        if (element instanceof CloudSharedLibraries) {
            return true;
        }
        if (element instanceof CloudSharedLibrary) {
            return false;
        }
        if (element instanceof PublishedModule) {
            return false;
        }
        return false;
    }

    public Object[] getElements(Object parentElement) {
        return this.getChildren(parentElement);
    }

    public void dispose() {
        super.dispose();
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            OracleCloudRuntime crt = (OracleCloudRuntime)rt.getAdapter(OracleCloudRuntime.class);
            if (crt != null) {
                if (this.cloudModuleListener != null) {
                    crt.getModules().detach(this.cloudModuleListener);
                }
                if (this.cloudShareLibsListener != null) {
                    crt.getSharedLibraries().detach(this.cloudShareLibsListener);
                }
            }
            ++n2;
        }
    }
}

