/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.actions;

import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServerBehaviour;
import oracle.eclipse.tools.cloud.server.internal.WhitelistScanToolRunner;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;

public class WhitelistScanAction
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private IStructuredSelection selection;

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    public void run(IAction action) {
        IProject selectedProject;
        if (this.selection != null && this.selection.getFirstElement() instanceof IProject && (selectedProject = (IProject)this.selection.getFirstElement()) != null) {
            WhitelistScanAction.scan(selectedProject);
        }
    }

    public static void scan(final IProject selectedProject) {
        try {
            if (!selectedProject.isOpen()) {
                return;
            }
            OracleCloudRuntime cloudRt = null;
            FacetedProject fproj = (FacetedProject)ProjectFacetsManager.create((IProject)selectedProject);
            for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt : fproj.getTargetedRuntimes()) {
                IRuntime rt1 = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)frt);
                if (rt1 != null && (cloudRt = (OracleCloudRuntime)rt1.loadAdapter(OracleCloudRuntime.class, null)) != null) break;
            }
            if (cloudRt == null) {
                String msg = Resources.requiresWlsRt;
                WhitelistScanAction.prompt(Resources.error, msg);
                return;
            }
            final OracleCloudRuntime crt = cloudRt;
            final IRuntime rt = crt.getRuntime();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        WeblogicServerRuntime wlsRt = (WeblogicServerRuntime)rt.loadAdapter(WeblogicServerRuntime.class, monitor);
                        IModule[] m = ServerUtil.getModules((IProject)selectedProject);
                        IModule rootModule = m[0];
                        String stageAreaPath = CloudUiPlugin.state().toOSString();
                        monitor.worked(10);
                        String archiveFile = OracleCloudServerBehaviour.exportModuleToArchive((IModule)rootModule, (String)stageAreaPath, (IProgressMonitor)monitor);
                        if (archiveFile == null) {
                            WhitelistScanAction.prompt(Resources.error, Resources.exportToWar);
                            return;
                        }
                        monitor.worked(10);
                        WhitelistScanToolRunner runner = new WhitelistScanToolRunner(crt, wlsRt, selectedProject, archiveFile);
                        IStatus ret = runner.execute(monitor);
                        if (ret != Status.OK_STATUS) {
                            String msg = "";
                            msg = ret.getException() != null ? String.valueOf(Resources.errorExecuteScan) + ret.getException().getMessage() : String.valueOf(msg) + Resources.errorFoundOnProj;
                            WhitelistScanAction.prompt(Resources.error, msg);
                        } else {
                            WhitelistScanAction.prompt(Resources.whiteListScan, Resources.scanSuccess);
                        }
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                    }
                }
            };
            Shell shell = Display.getDefault().getActiveShell();
            if (shell != null) {
                new ProgressMonitorDialog(shell).run(true, false, op);
            }
        }
        catch (Exception e) {
            CloudUiPlugin.log(e);
        }
    }

    private static void prompt(final String type, final String msg) {
        UIJob displayJob = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (type.equals(Resources.error)) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)type, (String)msg);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        page.showView("org.eclipse.ui.views.ProblemView");
                    }
                    catch (PartInitException partInitException) {}
                } else {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)type, (String)msg);
                }
                return Status.OK_STATUS;
            }
        };
        displayJob.schedule(500L);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    private static final class Resources
    extends NLS {
        public static String requiresWlsRt;
        public static String error;
        public static String exportToWar;
        public static String errorExecuteScan;
        public static String errorFoundOnProj;
        public static String scanSuccess;
        public static String whiteListScan;

        static {
            Resources.initializeMessages((String)WhitelistScanAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

