/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal.actions;

import oracle.eclipse.tools.cloud.AuthenticationException;
import oracle.eclipse.tools.cloud.CloudModules;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServerBehaviour;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibrary;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.server.internal.view.JobsLogView;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;

public class UndeployCloudModuleActionHandler
extends AbstractHandler {
    private Object cloudConnectionLock = new Object();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection ts;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (ts = (StructuredSelection)selection).getFirstElement() instanceof PublishedModule) {
            PublishedModule module = (PublishedModule)ts.getFirstElement();
            this.undeployPublishedModule(module);
        }
        return null;
    }

    public void undeployPublishedModule(final PublishedModule module) {
        try {
            String moduleType;
            String string = moduleType = module instanceof CloudSharedLibrary ? "shared library" : "module";
            if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)("Undeploy " + moduleType), (String)("Are you sure you want to undeploy the selected " + moduleType + "?"))) {
                return;
            }
            final Server server = (Server)module.server();
            final OracleCloudServerBehaviour behaviour = this.getOracleCloudServerBehaviour((IServer)server);
            if (behaviour == null) {
                return;
            }
            String jobName = String.format("Undeploy %s from Cloud", moduleType);
            Job undeployJob = new Job(jobName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Object object = UndeployCloudModuleActionHandler.this.cloudConnectionLock;
                        synchronized (object) {
                            IRuntime rt = behaviour.getServer().getRuntime();
                            OracleCloudRuntime crt = (OracleCloudRuntime)rt.loadAdapter(OracleCloudRuntime.class, null);
                            INuviaqDeployer deployer = crt.getNuviaqDeployer();
                            IStatus ret = null;
                            CloudModules moduleFetcherToRefresh = null;
                            if (module.isSharedLibrary()) {
                                monitor.beginTask("Undeploy shared library", 3000);
                                CloudSharedLibrary lib = (CloudSharedLibrary)module;
                                ret = deployer.undeployLibrary(lib.getLibrary(), monitor);
                                moduleFetcherToRefresh = lib.libraries();
                            } else {
                                monitor.beginTask("Undeploy module", 3000);
                                ret = deployer.undeploy(module.label(), monitor);
                                moduleFetcherToRefresh = crt.getModules();
                            }
                            JobsLogView.updateJobsView();
                            monitor.done();
                            if (!ret.isOK()) {
                                return ret;
                            }
                            moduleFetcherToRefresh.fetch(false, null);
                            server.setServerPublishState(1);
                            server.setServerStatus(null);
                        }
                    }
                    catch (AuthenticationException ae) {
                        return CloudUiPlugin.createErrorStatus("Error removing module from Oracle Cloud.", (Exception)((Object)ae));
                    }
                    catch (CoreException ce) {
                        return ce.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            undeployJob.setUser(true);
            undeployJob.schedule();
            JobsLogView.updateJobsView();
            server.setServerPublishState(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OracleCloudServerBehaviour getOracleCloudServerBehaviour(IServer server) {
        return (OracleCloudServerBehaviour)server.loadAdapter(OracleCloudServerBehaviour.class, null);
    }
}

