/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal;

import oracle.eclipse.tools.cloud.IOracleCloudServerConfig;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.server.internal.OracleCloudBaseWizardFragment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;

public final class OracleCloudServerWizardFragment
extends OracleCloudBaseWizardFragment {
    @Override
    protected String getTitle() {
        return OracleCloudTools.SERVER_TYPE.getName();
    }

    @Override
    protected String getDescription() {
        return Resources.wzdDescription;
    }

    @Override
    protected ImageDescriptor getImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.cloud.ui", (String)"images/cloud-wizban.gif");
    }

    @Override
    protected Element getModel() {
        TaskModel taskModel = this.getTaskModel();
        IServerWorkingCopy server = (IServerWorkingCopy)taskModel.getObject("server");
        OracleCloudServer cloudServer = (OracleCloudServer)server.loadAdapter(OracleCloudServer.class, null);
        IOracleCloudServerConfig model = cloudServer.getConfig();
        try {
            server.setAttribute("auto-publish-setting", 1);
        }
        catch (Exception e) {
            CloudUiPlugin.log(e);
        }
        if (server.getOriginal() == null) {
            OracleCloudRuntime rt = (OracleCloudRuntime)server.getRuntime().loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            String name = String.valueOf(rt.getTenantName()) + "-" + rt.getServiceName();
            model.setName(OracleCloudTools.findUniqueServerName((String)name));
        }
        return model;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        TaskModel taskModel = this.getTaskModel();
        IRuntime wc = (IRuntime)taskModel.getObject("runtime");
        IServerWorkingCopy swc = (IServerWorkingCopy)taskModel.getObject("server");
        String rtId = swc.getAttribute("runtime-id", "");
        if (rtId.length() == 0) {
            swc.setRuntime(wc);
        }
    }

    public void enter() {
        super.enter();
        TaskModel taskModel = this.getTaskModel();
        IServerWorkingCopy server = (IServerWorkingCopy)taskModel.getObject("server");
        String id1 = server.getRuntime().getId();
        if (server.getOriginal() == null) {
            IServer[] iServerArray = ServerCore.getServers();
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer s = iServerArray[n2];
                String id2 = s.getRuntime().getId();
                if (id1.equals(id2)) {
                    this.setError("Java Cloud Service instance with the same connection already exists.");
                    return;
                }
                ++n2;
            }
        }
        this.setError(null);
    }

    @Override
    protected String getUserInterfaceDef() {
        return "OracleCloudServerConfigForm";
    }

    @Override
    protected String getInitialFocus() {
        return IOracleCloudServerConfig.PROP_NAME.name();
    }

    private static final class Resources
    extends NLS {
        public static String wzdDescription;

        static {
            Resources.initializeMessages((String)OracleCloudServerWizardFragment.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

