/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.server.internal;

import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.IOracleCloudTargetConfig;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.JavaServiceDesc;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.ui.server.internal.OracleCloudBaseWizardFragment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;

public final class OracleCloudRuntimeWizardFragment
extends OracleCloudBaseWizardFragment {
    private IRuntime runtimeWc = null;

    @Override
    protected String getTitle() {
        return OracleCloudTools.RUNTIME_TYPE.getName();
    }

    @Override
    protected String getDescription() {
        return Resources.wzdDescription;
    }

    @Override
    protected ImageDescriptor getImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.cloud.ui", (String)"images/cloud-wizban.gif");
    }

    @Override
    protected Element getModel() {
        IOracleCloudTargetConfig cfg;
        block4: {
            this.runtimeWc = (IRuntime)this.getTaskModel().getObject("runtime");
            OracleCloudRuntime cloudRuntime = (OracleCloudRuntime)this.runtimeWc.loadAdapter(OracleCloudRuntime.class, null);
            cfg = cloudRuntime.getConfig();
            if (cfg.getProfileId().content() == null) {
                try {
                    Iterator iterator = OracleCloudTools.connections().iterator();
                    if (!iterator.hasNext()) break block4;
                    CloudConnection connection = (CloudConnection)iterator.next();
                    ICloudProfile p = connection.profile();
                    cfg.setProfileId((String)p.getId().content());
                    for (Object service : (List)connection.services().content()) {
                        if (!(service instanceof JavaServiceDesc)) continue;
                        cfg.setService(((JavaServiceDesc)service).getName());
                        break;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return cfg;
    }

    @Override
    protected String getUserInterfaceDef() {
        return "OracleCloudTargetConfigForm";
    }

    @Override
    protected String getInitialFocus() {
        return IOracleCloudTargetConfig.PROP_PROFILE_ID.name();
    }

    @Override
    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        IRuntimeWorkingCopy rwc = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (rwc.getOriginal() == null) {
            rwc.setName(null);
        }
    }

    public void enter() {
        super.enter();
        IRuntime runtime = (IRuntime)this.getTaskModel().getObject("runtime");
        if (runtime != this.runtimeWc && this.runtimeWc != null) {
            this.getTaskModel().putObject("runtime", (Object)this.runtimeWc);
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        IRuntime runtime = (IRuntime)this.getTaskModel().getObject("runtime");
        OracleCloudRuntime cloudRuntime = (OracleCloudRuntime)runtime.loadAdapter(OracleCloudRuntime.class, null);
        IOracleCloudTargetConfig config = cloudRuntime.getConfig();
        if (config.getName().text(false) == null) {
            cloudRuntime.getRuntimeWorkingCopy().setName(config.getName().text(true));
        }
        cloudRuntime.getVMInstall();
        RuntimeWorkingCopy rwc = (RuntimeWorkingCopy)runtime;
        rwc.save(true, monitor);
        cloudRuntime.reset();
    }

    private static final class Resources
    extends NLS {
        public static String wzdDescription;

        static {
            Resources.initializeMessages((String)OracleCloudRuntimeWizardFragment.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

