/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.OPCPortalServiceClient;
import oracle.eclipse.tools.cloud.ui.internal.UnsupportedVersionDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;

public class ValidateCloudConnectionActionHandler
extends SapphireActionHandler {
    Listener listener = null;

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        final ICloudProfile profile = (ICloudProfile)this.getPart().getModelElement();
        String userName = (String)profile.getUser().content();
        String passwd = (String)profile.getPassword().content();
        String idDomain = (String)profile.getIdentityDomain().content();
        this.setEnabled(userName != null && passwd != null && idDomain != null);
        this.listener = new Listener(){

            public void handle(Event arg0) {
                String userName = (String)profile.getUser().content();
                String passwd = (String)profile.getPassword().content();
                String idDomain = (String)profile.getIdentityDomain().content();
                ValidateCloudConnectionActionHandler.this.setEnabled(userName != null && passwd != null && idDomain != null);
            }
        };
        profile.getUser().attach(this.listener);
        profile.getPassword().attach(this.listener);
        profile.getIdentityDomain().attach(this.listener);
    }

    protected Object run(Presentation context) {
        ICloudProfile profile = (ICloudProfile)context.part().getModelElement();
        Status sts = ValidateCloudConnectionActionHandler.validateConnection(profile);
        if (!sts.ok()) {
            return sts;
        }
        org.eclipse.jface.dialogs.MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Success", (String)"Oracle Cloud connection test succeeded.");
        return Status.createOkStatus();
    }

    public static Status validateConnection(final ICloudProfile profile) {
        final Status[] ret = new Status[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Connecting to Oracle Cloud...", 300);
                OPCPortalServiceClient client = new OPCPortalServiceClient(profile);
                ret[0] = client.validate(monitor);
                monitor.worked(100);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, false, op);
        }
        catch (Exception exception) {}
        Status status = ret[0];
        if (!status.ok()) {
            if ("Oracle.Cloud.UnsupportedVersion".equals(status.type())) {
                UnsupportedVersionDialog.open(profile);
            } else {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Connection validation failed.", (IStatus)StatusBridge.create((Status)ret[0]), (int)4);
            }
        }
        return status;
    }
}

