/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemCopyJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class ProjectExplorerCloudDropAssistant
extends CommonDropAdapterAssistant {
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (target instanceof IContainer && LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
            List dndElementList = this.initializeLocalSelection(s);
            for (Object element : dndElementList) {
                if (element instanceof ResourceFacade) continue;
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        IContainer container = null;
        if (target instanceof IContainer) {
            container = (IContainer)target;
        } else if (target instanceof IFile) {
            container = ((IFile)target).getParent();
        }
        if (container != null) {
            IAdapterManager adapterManager = Platform.getAdapterManager();
            FolderFacade destination = (FolderFacade)adapterManager.getAdapter((Object)container, ResourceFacade.class);
            SetFactory resources = SetFactory.start();
            if (dropTargetEvent.data instanceof IStructuredSelection) {
                Iterator itr = ((StructuredSelection)dropTargetEvent.data).iterator();
                while (itr.hasNext()) {
                    resources.add((Object)((ResourceFacade)adapterManager.getAdapter(itr.next(), ResourceFacade.class)));
                }
            }
            if (resources.size() != 0) {
                new JavaServiceFileSystemCopyJob(resources.result(), destination, null).schedule();
            }
        }
        return Status.OK_STATUS;
    }

    private List initializeLocalSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            List list = Collections.EMPTY_LIST;
        }
        List dndElementList = ((IStructuredSelection)s).toList();
        return dndElementList;
    }
}

