/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import oracle.eclipse.tools.cloud.dev.BuiltInQuery;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.dev.UserDefinedQuery;
import oracle.eclipse.tools.cloud.dev.internal.GitCommitUtil;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DeActivateActionDelegate
implements IViewActionDelegate {
    protected Object element = null;
    protected TreePath path = null;
    protected CloudProfileView cloudView = null;

    public void run(IAction action) {
        this.doDeactivate(action);
    }

    public void doDeactivate(IAction action) {
        if (this.element != null) {
            if (this.element instanceof CloudRepositoryNode) {
                CloudRepositoryNode gitRepo = (CloudRepositoryNode)this.element;
                if (!DeActivateActionDelegate.deactivateGitRepo(gitRepo, this.cloudView)) {
                    return;
                }
            } else if (this.element instanceof UserDefinedQuery) {
                UserDefinedQuery query = (UserDefinedQuery)this.element;
                RepositoryQuery rq = query.getRepositoryQuery();
                DevCloudCore.deleteQuery((RepositoryQuery)rq);
                final TaskService ts = query.getTaskService();
                final String name = rq.getSummary();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuiltInQuery bq = ts.findBuiltInQuery(name);
                        if (bq != null) {
                            DeActivateActionDelegate.this.cloudView.tableViewer.setSelection((ISelection)new StructuredSelection((Object)bq));
                        }
                    }
                });
            }
        }
    }

    public static boolean deactivateGitRepo(CloudRepositoryNode gitLocal, final CloudProfileView cloudView) {
        if (gitLocal != null) {
            final CloudProjectService cps = gitLocal.getGitRepoNode().getCloudProjectService();
            JobChangeAdapter lstner = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    super.done(event);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            cloudView.refresh(cps);
                        }
                    });
                }
            };
            return GitCommitUtil.deactivateGitRepo((RepositoryNode)gitLocal, (IJobChangeListener)lstner);
        }
        return true;
    }

    public void setSelection(Object obj) {
        this.element = obj;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection ts = null;
        ts = (TreeSelection)selection;
        if (ts.getPaths().length > 1 || ts.getPaths().length == 0) {
            action.setEnabled(false);
            return;
        }
        this.path = ts.getPaths()[0];
        this.element = ts.getFirstElement();
    }

    public void init(IViewPart view) {
        if (view instanceof CloudProfileView) {
            this.cloudView = (CloudProfileView)view;
        }
    }

    public static boolean promprConfirmationDialog(String message) {
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)message);
    }
}

