/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ConnectionState;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.internal.FetchFailedNode;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.cnf.ServerContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.BaseCellLabelProvider;
import org.osgi.framework.Bundle;

public class CloudViewLabelProvider
extends BaseCellLabelProvider {
    private ImageRegistry imageRegistry = null;
    private final String IMG_CLOUD_SERVICE = "images/cloud.png";
    private final String IMG_DB_SERVICE = "images/database.png";
    private final String IMG_DB_SERVICE_INACTVIE = "images/DatabaseServiceInnactive.png";
    private final String IMG_JAVA_SERVICE = "images/java-service.png";
    private final String IMG_JAVA_SERVICE_INACTIVE = "images/JavaServiceInnactive.png";
    private final String IMG_FETCHING_REMOTE_DATA = "images/FetchingRemoteData.png";

    public CloudViewLabelProvider() {
        this.initImages();
    }

    protected void getImageRegistry() {
        if (this.imageRegistry == null) {
            if (Display.getCurrent() != null) {
                this.imageRegistry = new ImageRegistry(Display.getCurrent());
            } else if (PlatformUI.isWorkbenchRunning()) {
                this.imageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
            } else {
                throw new SWTError(22);
            }
        }
    }

    public String getText(Object element) {
        if (element instanceof CloudConnection) {
            CloudConnection connection = (CloudConnection)element;
            ConnectionState state = (ConnectionState)connection.profile().getConnectionState().content();
            String stateText = "";
            if (state == ConnectionState.ACCOUNT_LOCKED) {
                stateText = " [Account is locked]";
            }
            return String.valueOf(connection.name()) + stateText;
        }
        if (element instanceof FetchingRemoteDataNode) {
            return "Fetching...";
        }
        if (element instanceof FetchFailedNode) {
            return "Unavailable...";
        }
        if (element == ServerContentProvider.INITIALIZING) {
            return "View Initializing...";
        }
        if (element instanceof IWorkspaceRoot) {
            return Platform.getResourceString((Bundle)ServerUIPlugin.getInstance().getBundle(), (String)"%viewServers");
        }
        if (element instanceof IServer) {
            String profileId;
            CloudConnection connection;
            IServer server = (IServer)element;
            String name = server.getName();
            if (name.contains("-") && (connection = OracleCloudTools.connection((IServer)server)) != null && name.startsWith(profileId = (String)connection.profile().getIdentityDomain().content()) && name.length() > profileId.length()) {
                name = name.substring(profileId.length() + 1);
                return name;
            }
            return null;
        }
        if (element instanceof ServiceDesc) {
            ServiceDesc service = (ServiceDesc)element;
            return service.getName();
        }
        return null;
    }

    private Image createImage(String path) {
        URL url = CloudUiPlugin.bundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }

    private void initImages() {
        if (this.imageRegistry == null) {
            this.getImageRegistry();
            this.imageRegistry.put("images/cloud.png", this.createImage("images/cloud.png"));
            this.imageRegistry.put("images/database.png", this.createImage("images/database.png"));
            this.imageRegistry.put("images/DatabaseServiceInnactive.png", this.createImage("images/DatabaseServiceInnactive.png"));
            this.imageRegistry.put("images/java-service.png", this.createImage("images/java-service.png"));
            this.imageRegistry.put("images/JavaServiceInnactive.png", this.createImage("images/JavaServiceInnactive.png"));
            this.imageRegistry.put("images/FetchingRemoteData.png", this.createImage("images/FetchingRemoteData.png"));
        }
    }

    public void dispose() {
        super.dispose();
        this.imageRegistry.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof CloudConnection) {
            return this.imageRegistry.get("images/cloud.png");
        }
        if (element instanceof FetchingRemoteDataNode) {
            return this.imageRegistry.get("images/FetchingRemoteData.png");
        }
        if (element instanceof FetchFailedNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof ServiceDesc) {
            ServiceDesc sd = (ServiceDesc)element;
            if (sd.getType() == ServiceDesc.TYPE.DB) {
                return this.imageRegistry.get("images/DatabaseServiceInnactive.png");
            }
            if (sd.getType() == ServiceDesc.TYPE.JCS) {
                return this.imageRegistry.get("images/JavaServiceInnactive.png");
            }
        } else if (element instanceof IServer) {
            return this.imageRegistry.get("images/java-service.png");
        }
        return null;
    }

    Set<File> getWorkspaceProjectFolders() {
        HashSet<File> ret = new HashSet<File>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            File f = p.getLocation().toFile();
            ret.add(f);
            ++n2;
        }
        return ret;
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof IServer && property.equalsIgnoreCase("ICON")) {
            return true;
        }
        return true;
    }

    public Image getColumnImage(Object element, int index) {
        return null;
    }

    public String getColumnText(Object element, int index) {
        return null;
    }
}

