/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.eclipse.tools.cloud.ui.profile.DeactivateServerAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.cnf.ServerActionProvider;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;

public class CloudServerActionProvider
extends ServerActionProvider {
    private ICommonActionExtensionSite actionSite;
    private DeactivateServerAction deactivateAction;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.deactivateAction = new DeactivateServerAction((TreeViewer)cv, wsSite.getSelectionProvider());
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deactivateAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.removeAll();
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.search"));
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        Shell shell = this.actionSite.getViewSite().getShell();
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        IServer server = null;
        IModule[] module = null;
        ArrayList multipleModulesOnOneServer = null;
        if (selection != null && !selection.isEmpty()) {
            multipleModulesOnOneServer = this.getMultipleModulesOnOneServer(selection);
            Iterator iterator = selection.iterator();
            Object obj = iterator.next();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                server = ms.server;
                module = ms.module;
            }
            if (iterator.hasNext()) {
                server = null;
                module = null;
            }
        }
        if (server != null && module == null) {
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnfeditSectionStart"));
            this.deactivateAction.setText("Deactivate");
            menu.add((IAction)this.deactivateAction);
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.controlServerSectionStart"));
            int i = 0;
            while (i < this.actions.length) {
                AbstractServerAction act;
                if (!(this.actions[i] instanceof AbstractServerAction) || (act = (AbstractServerAction)this.actions[i]).accept(server)) {
                    menu.add((IAction)this.actions[i]);
                }
                ++i;
            }
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.controlServerSectionEnd"));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.serverEtcSectionStart"));
            menu.add((IAction)this.actionModifyModules);
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.serverEtcSectionEnd"));
            menu.add((IContributionItem)new Separator());
        } else if (server != null && module != null) {
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionStart"));
            if (module.length == 1) {
                menu.add((IAction)new RemoveModuleAction(shell, server, (IModule)module[0]));
            }
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionEnd"));
        } else if (server == null && module == null && multipleModulesOnOneServer != null) {
            server = selection.getFirstElement() == null ? null : ((ModuleServer)selection.getFirstElement()).getServer();
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionStart"));
            menu.add((IAction)new RemoveModuleAction(shell, server, multipleModulesOnOneServer.toArray(new IModule[multipleModulesOnOneServer.size()])));
            menu.add((IContributionItem)this.invisibleSeparator("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionEnd"));
        }
        if (module == null) {
            menu.add((IContributionItem)new Separator("additions"));
            menu.add((IContributionItem)new Separator("additions-end"));
            menu.add((IAction)this.propertiesAction);
        }
    }

    private Separator invisibleSeparator(String s) {
        Separator sep = new Separator(s);
        sep.setVisible(false);
        return sep;
    }
}

