/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ConnectionState;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.ui.profile.NewCloudProfileWizard;
import oracle.eclipse.tools.cloud.ui.profile.ValidateCloudConnectionActionHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphirePropertyPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public final class CloudProfilePropertypage
extends SapphirePropertyPage {
    private CloudConnection connection;
    private ICloudProfile profileWorkingCopy;

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.connection = (CloudConnection)element.getAdapter(CloudConnection.class);
        this.profileWorkingCopy = (ICloudProfile)ICloudProfile.TYPE.instantiate();
        this.profileWorkingCopy.copy((Element)this.connection.profile());
        this.init((Element)this.profileWorkingCopy, DefinitionLoader.sdef(NewCloudProfileWizard.class).form("CloudProfileConfigForm"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public boolean performOk() {
        if (!OracleCloudTools.isDebugMode() && !ValidateCloudConnectionActionHandler.validateConnection(this.profileWorkingCopy).ok()) {
            return false;
        }
        this.connection.update(this.profileWorkingCopy);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Connect...", -1);
                CloudProfilePropertypage.this.connection.services().fetch(false, monitor);
                ICloudProfile p = CloudProfilePropertypage.this.connection.profile();
                p.setConnectionState(ConnectionState.CONNECTED);
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            CloudPlugin.log((Exception)e);
        }
        return super.performOk();
    }

    public void dispose() {
        super.dispose();
        this.profileWorkingCopy.dispose();
    }
}

