/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.profile;

import java.io.File;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.cloud.java.FileFacade;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemCopyJob;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class CloudProfileDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (!(target instanceof ResourceFacade)) {
            return Status.CANCEL_STATUS;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
            List dndElementList = this.initializeLocalSelection(s);
            return this.validateEclipseDrop(target, dndElementList);
        }
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private List initializeLocalSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            List list = Collections.EMPTY_LIST;
        }
        List dndElementList = ((IStructuredSelection)s).toList();
        return dndElementList;
    }

    private IStatus validateEclipseDrop(Object target, List elements) {
        if (target instanceof ResourceFacade) {
            JavaServiceFolder dir = null;
            if (target instanceof JavaServiceFolder) {
                dir = (JavaServiceFolder)target;
            } else if (target instanceof JavaServiceFile) {
                JavaServiceFile cfile = (JavaServiceFile)target;
                dir = cfile.parent();
            }
            JavaServiceFolder targetDir = dir;
            for (Object element : elements) {
                IResource res2;
                IAdapterManager adapterManager;
                ResourceFacade res;
                if (element instanceof IResource) continue;
                if (element instanceof ResourceFacade) {
                    FolderFacade sourceParent = ((ResourceFacade)element).parent();
                    if (sourceParent == targetDir) {
                        return Status.CANCEL_STATUS;
                    }
                    if (element instanceof JavaServiceFolder) {
                        JavaServiceFolder sourceFolder = (JavaServiceFolder)element;
                        if (sourceFolder == targetDir) {
                            return Status.CANCEL_STATUS;
                        }
                        if (targetDir.descendant((FolderFacade)sourceFolder)) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
                if ((res = (ResourceFacade)(adapterManager = Platform.getAdapterManager()).getAdapter(element, ResourceFacade.class)) != null || (res2 = (IResource)adapterManager.getAdapter(element, IResource.class)) != null) continue;
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        FolderFacade destination = target instanceof FolderFacade ? (FolderFacade)target : ((FileFacade)target).parent();
        SetFactory resources = SetFactory.start();
        IAdapterManager adapterManager = Platform.getAdapterManager();
        if (FileTransfer.getInstance().isSupportedType(dropAdapter.getCurrentTransfer())) {
            String[] stringArray = (String[])dropTargetEvent.data;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                resources.add((Object)((ResourceFacade)adapterManager.getAdapter((Object)new File(name), ResourceFacade.class)));
                ++n2;
            }
            dropTargetEvent.detail = 1;
        } else if (dropTargetEvent.data instanceof TreeSelection) {
            for (Object element : (TreeSelection)dropTargetEvent.data) {
                ResourceFacade res = (ResourceFacade)adapterManager.getAdapter(element, ResourceFacade.class);
                if (res != null) {
                    resources.add((Object)res);
                    continue;
                }
                IResource res2 = (IResource)adapterManager.getAdapter(element, IResource.class);
                if (res2 == null) continue;
                res = (ResourceFacade)adapterManager.getAdapter((Object)res2, ResourceFacade.class);
                resources.add((Object)res);
            }
            dropTargetEvent.detail = 1;
        } else {
            dropTargetEvent.detail = 0;
            return Status.OK_STATUS;
        }
        if (resources.size() > 0) {
            new JavaServiceFileSystemCopyJob(resources.result(), destination, null).schedule();
        }
        return Status.OK_STATUS;
    }
}

