/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.internal;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import oracle.eclipse.tools.cloud.ui.profile.CloudViewActionHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveFiltersOperation;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ToggleInactiveElementsActionHandler
extends CloudViewActionHandler {
    private static final String HIDE_INACTIVE_CLOUD_NODE_ID = "oracle.eclipse.tools.cloud.ui.hideInactiveNodesFilter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CloudProfileView cloudView = this.findCloudProfileView();
        Set<String> filterIds = this.getEnabledFilters();
        Command command = event.getCommand();
        boolean orginalVal = HandlerUtil.toggleCommandState((Command)command);
        if (orginalVal) {
            filterIds.remove(HIDE_INACTIVE_CLOUD_NODE_ID);
        } else {
            filterIds.add(HIDE_INACTIVE_CLOUD_NODE_ID);
        }
        UpdateActiveFiltersOperation updateFilters = new UpdateActiveFiltersOperation(cloudView.getCommonViewer(), filterIds.toArray(new String[filterIds.size()]));
        updateFilters.execute(null, null);
        return null;
    }

    private Set<String> getEnabledFilters() {
        CloudProfileView cloudView = this.findCloudProfileView();
        INavigatorContentService contentService = cloudView.getCommonViewer().getCommonNavigator().getNavigatorContentService();
        ICommonFilterDescriptor[] visibleFilters = contentService.getFilterService().getVisibleFilterDescriptors();
        HashSet<String> filterIds = new HashSet<String>();
        int i = 0;
        while (i < visibleFilters.length) {
            String id = visibleFilters[i].getId();
            filterIds.add(id);
            ++i;
        }
        return filterIds;
    }
}

