/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.internal;

import java.lang.reflect.Field;
import java.net.URL;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.IOracleCloudTargetConfig;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.NuviaqToolsFactory;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;

public final class OracleCloudTestConnectionActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        IOracleCloudTargetConfig cfg = (IOracleCloudTargetConfig)context.part().getModelElement();
        IStatus sts = OracleCloudTestConnectionActionHandler.validationJCSConnection(cfg);
        if (!sts.isOK()) {
            return sts;
        }
        org.eclipse.jface.dialogs.MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Resources.testDlgTitl1, (String)Resources.testSuccess);
        return Status.OK_STATUS;
    }

    public static IStatus validationJCSConnection(IOracleCloudTargetConfig cfg) {
        try {
            CloudConnection connection = OracleCloudTools.connection((String)((String)cfg.getProfileId().content()));
            if (connection == null) {
                throw new CoreException(CloudUiPlugin.createErrorStatus("Cloud connection not found.", null));
            }
            ICloudProfile profile = connection.profile();
            String adminUrl = (String)profile.getAdminUrl().content();
            String userName = (String)profile.getUser().content();
            String password = (String)profile.getPassword().content();
            String systemName = (String)profile.getIdentityDomain().content();
            URL pingUrl = new URL(adminUrl);
            String serviceName = (String)cfg.getService().content();
            String hostName = pingUrl.getHost();
            if (serviceName == null || userName == null || password == null || hostName == null) {
                IStatus sts = CloudUiPlugin.createErrorStatus("Missing Oracle Cloud connection information", null);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Resources.testFailed, (String)Resources.specifyConnInfo, (IStatus)sts, (int)4);
                IStatus iStatus = sts;
                return iStatus;
            }
            try {
                INuviaqDeployer deployer = NuviaqToolsFactory.getInstance().createDeployer();
                deployer.pingCloudService(adminUrl, userName, password, systemName, serviceName);
                deployer.dispose();
            }
            catch (Exception e) {
                IStatus status = CloudUiPlugin.createErrorStatus(e.getMessage(), e);
                OracleCloudTestConnectionActionHandler.promptConnectionTestFailure(status);
                IStatus iStatus = status;
                return iStatus;
            }
        }
        finally {
            OracleCloudTestConnectionActionHandler.clearAuthCacheValue();
        }
        return Status.OK_STATUS;
    }

    private static void clearAuthCacheValue() {
        try {
            Class<?> cacheContainer = OracleCloudTestConnectionActionHandler.class.getClassLoader().loadClass("sun.net.www.protocol.http.AuthCacheValue");
            Class<?> impl = OracleCloudTestConnectionActionHandler.class.getClassLoader().loadClass("sun.net.www.protocol.http.AuthCacheImpl");
            Field cacheField = cacheContainer.getDeclaredField("cache");
            cacheField.setAccessible(true);
            cacheField.set(null, impl.newInstance());
            cacheField.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void promptConnectionTestFailure(IStatus status) {
        String dialogTitle = Resources.testFailed;
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)dialogTitle, (String)dialogTitle, (IStatus)status, (int)4);
    }

    private static final class Resources
    extends NLS {
        public static String specifyConnInfo;
        public static String testDlgTitl1;
        public static String testFailed;
        public static String testSuccess;

        static {
            Resources.initializeMessages((String)OracleCloudTestConnectionActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

