/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.RemoteDataSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public final class CloudRefreshActionHandler
extends AbstractHandler {
    public void setEnabled(Object ctxt) {
        IEvaluationContext context = (IEvaluationContext)ctxt;
        Object selection = context.getVariable("selection");
        if (selection instanceof IStructuredSelection) {
            Iterator itr = ((IStructuredSelection)selection).iterator();
            while (itr.hasNext()) {
                Set<RemoteData<?>> set = this.extract(itr.next());
                if (set == null) continue;
                for (RemoteData<?> data : set) {
                    if (data.disposed() || !data.available() && !data.fetchFailed()) continue;
                    this.setBaseEnabled(true);
                    return;
                }
            }
        }
        this.setBaseEnabled(false);
    }

    public final Object execute(ExecutionEvent event) {
        Set setOfData;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        SetFactory setOfDataFactory = SetFactory.start();
        if (selection instanceof IStructuredSelection) {
            Iterator itr = ((IStructuredSelection)selection).iterator();
            while (itr.hasNext()) {
                setOfDataFactory.add(this.extract(itr.next()));
            }
        }
        if (!(setOfData = setOfDataFactory.result()).isEmpty()) {
            Object op;
            if (setOfData.size() == 1) {
                final RemoteData data = (RemoteData)setOfData.iterator().next();
                op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        data.fetch(false, monitor);
                    }
                };
            } else {
                op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Fetching...", setOfData.size());
                        for (RemoteData data : setOfData) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            data.fetch(false, null);
                            monitor.worked(1);
                        }
                        monitor.done();
                    }
                };
            }
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                CloudPlugin.log((Exception)e);
            }
        }
        return null;
    }

    private Set<RemoteData<?>> extract(Object selection) {
        return (RemoteDataSet)Platform.getAdapterManager().getAdapter(selection, RemoteDataSet.class);
    }
}

