/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import oracle.eclipse.tools.cloud.java.ConflictResolver;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.fileSystem.CloudTextFileInput;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemOpenActionHandler;
import oracle.eclipse.tools.cloud.ui.fileSystem.internal.PromptingJavaServiceFileSystemConflictResolver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public final class JavaServiceFileSystemRenameJob
extends Job {
    @Text(value="Renaming")
    private static LocalizableText jobName;
    @Text(value="Renaming...")
    private static LocalizableText taskName;
    private final ResourceFacade resource;
    private final String newName;
    private final CommonNavigator navigator;

    static {
        LocalizableText.init(JavaServiceFileSystemRenameJob.class);
    }

    public JavaServiceFileSystemRenameJob(ResourceFacade resource, String newName, CommonNavigator navigator) {
        super(jobName.text());
        this.resource = resource;
        this.newName = newName;
        this.navigator = navigator;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(taskName.text(), -1);
        try {
            PromptingJavaServiceFileSystemConflictResolver conflictResolver = new PromptingJavaServiceFileSystemConflictResolver(PromptingJavaServiceFileSystemConflictResolver.Mode.SINGLE);
            final ResourceFacade renamed = this.resource.rename(this.newName, (ConflictResolver)conflictResolver);
            if (renamed != null && this.navigator != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                        int n = iEditorReferenceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CloudTextFileInput cin;
                            JavaServiceFile file;
                            IEditorInput in;
                            IEditorReference e = iEditorReferenceArray[n2];
                            IEditorPart part = e.getEditor(false);
                            if (part != null && (in = part.getEditorInput()) instanceof CloudTextFileInput && (file = (JavaServiceFile)(cin = (CloudTextFileInput)in).getCloudFile()) == JavaServiceFileSystemRenameJob.this.resource && renamed instanceof JavaServiceFile) {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(part, false);
                                JavaServiceFileSystemOpenActionHandler.openCloudFile((JavaServiceFile)renamed);
                            }
                            ++n2;
                        }
                    }
                });
                final CommonViewer viewer = this.navigator.getCommonViewer();
                Control control = viewer.getControl();
                if (!control.isDisposed()) {
                    control.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            viewer.setSelection((ISelection)new StructuredSelection((Object)renamed));
                        }
                    });
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

