/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.fileSystem.ICloudFile;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemRenameJob;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

public final class JavaServiceFileSystemRenameActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            StructuredSelection ts = (StructuredSelection)selection;
            ResourceFacade resource = (ResourceFacade)ts.getFirstElement();
            ICloudFile newFile = (ICloudFile)ICloudFile.TYPE.instantiate();
            try {
                String fileName;
                newFile.setName(resource.name());
                SapphireDialog dialog = new SapphireDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (Element)newFile, DefinitionLoader.sdef(JavaServiceFileSystemRenameActionHandler.class).dialog());
                if (dialog.open() == 0 && !(fileName = ((FileName)newFile.getName().content()).full()).equals(resource.name())) {
                    new JavaServiceFileSystemRenameJob(resource, fileName, (CommonNavigator)HandlerUtil.getActivePart((ExecutionEvent)event)).schedule();
                }
            }
            finally {
                newFile.dispose();
            }
        }
        return null;
    }
}

