/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.cloud.java.FileFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.ui.fileSystem.CloudTextFileInput;
import oracle.eclipse.tools.cloud.ui.fileSystem.CloudTextFileStorage;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaServiceFileSystemOpenActionHandler
extends AbstractHandler {
    static final String DEFAULT_TEXT_EDITOR = "org.eclipse.ui.DefaultTextEditor";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection ts;
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = (ts = (StructuredSelection)selection).getFirstElement()) instanceof JavaServiceFile) {
            JavaServiceFileSystemOpenActionHandler.openCloudFile((JavaServiceFile)element);
        }
        return null;
    }

    private static String findEditorIdFor(String fileName) {
        String foundEditor = null;
        EditorRegistry registry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
        IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(fileName);
        int i = 0;
        while (i < contentTypes.length) {
            int j = 0;
            IEditorDescriptor[] array = registry.getEditorsForContentType(contentTypes[i]);
            if (j < array.length) {
                IEditorDescriptor editor = array[j];
                foundEditor = editor.getId();
            }
            if (foundEditor != null) break;
            ++i;
        }
        return foundEditor;
    }

    public static void openCloudFile(JavaServiceFile file) {
        CloudTextFileStorage storage = new CloudTextFileStorage(file);
        CloudTextFileInput editorInput = new CloudTextFileInput(storage);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CloudTextFileInput sin;
                IEditorReference ref = iEditorReferenceArray[n2];
                IEditorInput in = ref.getEditorInput();
                if (in instanceof CloudTextFileInput && (sin = (CloudTextFileInput)in).getCloudFile().path().equals((Object)file.path())) {
                    page.activate((IWorkbenchPart)ref.getEditor(false));
                    return;
                }
                ++n2;
            }
            String foundEditor = JavaServiceFileSystemOpenActionHandler.findEditorIdFor(file.name());
            if (foundEditor == null) {
                IEditorDescriptor editorDesc;
                EditorRegistry registry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
                if (registry.isSystemExternalEditorAvailable(file.name()) && (editorDesc = registry.findEditor("org.eclipse.ui.systemExternalEditor")) != null) {
                    foundEditor = editorDesc.getId();
                }
                if (foundEditor != null) {
                    try {
                        String name = file.name();
                        int lastdot = name.lastIndexOf(46);
                        String prefix = name.substring(0, lastdot);
                        String suffix = name.substring(lastdot);
                        File tempFile = File.createTempFile(String.valueOf(prefix) + "-temp-", suffix);
                        tempFile.deleteOnExit();
                        assert (tempFile.exists() && tempFile.canWrite());
                        InputStream in = file.content();
                        try {
                            FileOutputStream out = new FileOutputStream(tempFile.getPath(), false);
                            try {
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                            }
                            catch (Throwable throwable) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        catch (Throwable throwable) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(tempFile.toURI());
                        editorInput = new FileStoreEditorInput(fileStore);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    foundEditor = DEFAULT_TEXT_EDITOR;
                }
            }
            final IEditorPart textEditor = page.openEditor((IEditorInput)editorInput, foundEditor);
            final ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
            commandService.addExecutionListener(new IExecutionListener(){
                IEditorPart editor = null;

                public void preExecute(String commandId, ExecutionEvent event) {
                    this.editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                }

                public void postExecuteSuccess(String commandId, Object returnValue) {
                    if (this.editor == textEditor) {
                        if (commandId.equals("org.eclipse.ui.file.close")) {
                            commandService.removeExecutionListener((IExecutionListener)this);
                            return;
                        }
                        if (!commandId.equals("org.eclipse.ui.file.save") && !commandId.equals("org.eclipse.ui.file.saveAll")) {
                            return;
                        }
                        CloudTextFileInput ci = (CloudTextFileInput)this.editor.getEditorInput();
                        ITextEditor te = null;
                        te = this.editor instanceof ITextEditor ? (ITextEditor)this.editor : (ITextEditor)this.editor.getAdapter(ITextEditor.class);
                        if (te != null) {
                            IDocument doc = te.getDocumentProvider().getDocument((Object)ci);
                            ci.getCloudFile().write((InputStream)new ByteArrayInputStream(doc.get().getBytes(StandardCharsets.UTF_8)));
                        } else {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Saving to Oracle Cloud is not supported by this Editor.\nPlease use Save As to save the file to a local directory and upload to Cloud.");
                        }
                    }
                }

                public void postExecuteFailure(String commandId, ExecutionException exception) {
                }

                public void notHandled(String commandId, NotHandledException exception) {
                }
            });
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public static IEditorInput getEditorInput(JavaServiceFile file) {
        CloudTextFileStorage storage = new CloudTextFileStorage(file);
        return new CloudTextFileInput(storage);
    }

    public static FileFacade getCloudFile(IEditorInput editorInput) {
        if (editorInput instanceof CloudTextFileInput) {
            CloudTextFileInput sin = (CloudTextFileInput)editorInput;
            return sin.getCloudFile();
        }
        return null;
    }
}

