/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import java.net.URL;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.java.JavaServiceFileSystem;
import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public final class JavaServiceFileSystemLabelProvider
extends LabelProvider {
    private Image folderImage = null;
    private Image fileImage = null;

    public JavaServiceFileSystemLabelProvider() {
        this.initImages();
    }

    private void initImages() {
        if (this.folderImage == null) {
            this.folderImage = this.createImage("images/folder.png");
            this.fileImage = this.createImage("images/file.png");
        }
    }

    private Image createImage(String path) {
        URL url = CloudUiPlugin.bundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }

    public String getText(Object element) {
        if (element instanceof JavaServiceFileSystem) {
            return "Files";
        }
        if (element instanceof ResourceFacade) {
            return ((ResourceFacade)element).name();
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof JavaServiceFolder) {
            return this.folderImage;
        }
        if (element instanceof JavaServiceFile) {
            return this.fileImage;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.folderImage.dispose();
        this.fileImage.dispose();
    }
}

