/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import java.util.List;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.fileSystem.CloudTextFileInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;

public final class JavaServiceFileSystemDeleteJob
extends Job {
    @Text(value="Deleting")
    private static LocalizableText jobName;
    @Text(value="Deleting...")
    private static LocalizableText taskName;
    @Text(value="Deleting \"{0}\"...")
    private static LocalizableText taskNameDetailed;
    @Text(value="Encountered an error while deleting \"{0}\". {1}")
    private static LocalizableText errorMessage;
    private final List<ResourceFacade> resources;
    private final CommonNavigator navigator;

    static {
        LocalizableText.init(JavaServiceFileSystemDeleteJob.class);
    }

    public JavaServiceFileSystemDeleteJob(List<ResourceFacade> resources, CommonNavigator navigator) {
        super(jobName.text());
        this.resources = resources;
        this.navigator = navigator;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        int count = this.resources.size();
        monitor.beginTask(taskName.text(), count == 1 ? -1 : count);
        try {
            for (final ResourceFacade resource : this.resources) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.setTaskName(taskNameDetailed.format(new Object[]{resource.name()}));
                try {
                    resource.delete();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            try {
                                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                                int n = iEditorReferenceArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CloudTextFileInput sin;
                                    IEditorReference ref = iEditorReferenceArray[n2];
                                    IEditorInput in = ref.getEditorInput();
                                    if (in instanceof CloudTextFileInput && (sin = (CloudTextFileInput)in).getCloudFile().path().equals((Object)resource.path())) {
                                        page.closeEditor(ref.getEditor(false), false);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception exception) {}
                        }
                    });
                }
                catch (Exception e) {
                    IStatus iStatus = CloudUiPlugin.createErrorStatus(errorMessage.format(new Object[]{resource.name(), e.getMessage()}), null);
                    monitor.done();
                    return iStatus;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

