/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import java.util.Iterator;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemDeleteJob;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

public final class JavaServiceFileSystemDeleteActionHandler
extends AbstractHandler {
    @Text(value="Delete Resource")
    private static LocalizableText confirmationDialogTitleForOne;
    @Text(value="Delete Resources")
    private static LocalizableText confirmationDialogTitleForSeveral;
    @Text(value="Are you sure you want to delete \"{0}\" from the cloud?")
    private static LocalizableText confirmationDialogMessageForOne;
    @Text(value="Are you sure you want to delete the {0} selected resources from the cloud?")
    private static LocalizableText confirmationDialogMessageForSeveral;

    static {
        LocalizableText.init(JavaServiceFileSystemDeleteActionHandler.class);
    }

    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            StructuredSelection ts = (StructuredSelection)selection;
            boolean delete = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)(ts.size() == 1 ? confirmationDialogTitleForOne.text() : confirmationDialogTitleForSeveral.text()), (String)(ts.size() == 1 ? confirmationDialogMessageForOne.format(new Object[]{((ResourceFacade)ts.getFirstElement()).name()}) : confirmationDialogMessageForSeveral.format(new Object[]{ts.size()})));
            if (delete) {
                ListFactory resourcesListFactory = ListFactory.start();
                Iterator itr = ts.iterator();
                while (itr.hasNext()) {
                    resourcesListFactory.add((Object)((ResourceFacade)itr.next()));
                }
                new JavaServiceFileSystemDeleteJob(resourcesListFactory.result(), (CommonNavigator)HandlerUtil.getActivePart((ExecutionEvent)event)).schedule();
            }
        }
        return null;
    }
}

