/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public final class JavaServiceFileSystemCreateFolderJob
extends Job {
    @Text(value="Creating Folder")
    private static LocalizableText jobName;
    @Text(value="Creating folder \"{0}\"...")
    private static LocalizableText taskName;
    private final JavaServiceFolder parent;
    private final String name;
    private final CommonNavigator navigator;

    static {
        LocalizableText.init(JavaServiceFileSystemCreateFolderJob.class);
    }

    public JavaServiceFileSystemCreateFolderJob(JavaServiceFolder parent, String name, CommonNavigator navigator) {
        super(jobName.text());
        this.parent = parent;
        this.name = name;
        this.navigator = navigator;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(taskName.format(new Object[]{this.name}), -1);
        try {
            CommonViewer viewer;
            Control control;
            final FolderFacade folder = this.parent.folder(this.name, true);
            if (folder == null) {
                IStatus iStatus = CloudUiPlugin.createErrorStatus("Error creating folder " + this.name, null);
                return iStatus;
            }
            if (this.navigator != null && !(control = (viewer = this.navigator.getCommonViewer()).getControl()).isDisposed()) {
                control.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)folder));
                    }
                });
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

