/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.ui.fileSystem.ICloudFile;
import oracle.eclipse.tools.cloud.ui.fileSystem.JavaServiceFileSystemCreateFolderJob;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

public final class JavaServiceFileSystemCreateFolderActionHandler
extends AbstractHandler {
    @Text(value="Already Exists")
    private static LocalizableText alreadyExistsDialogTitle;
    @Text(value="\"{0}\" already exists.")
    private static LocalizableText alreadyExistsDialogMessage;

    static {
        LocalizableText.init(JavaServiceFileSystemCreateFolderActionHandler.class);
    }

    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            StructuredSelection ts = (StructuredSelection)selection;
            JavaServiceFolder parent = (JavaServiceFolder)ts.getFirstElement();
            ICloudFile newFile = (ICloudFile)ICloudFile.TYPE.instantiate();
            try {
                SapphireDialog dialog = new SapphireDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (Element)newFile, DefinitionLoader.sdef(JavaServiceFileSystemCreateFolderActionHandler.class).dialog());
                if (dialog.open() == 0) {
                    String name = ((FileName)newFile.getName().content()).full();
                    if (parent.contains(name)) {
                        MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)alreadyExistsDialogTitle.text(), (String)alreadyExistsDialogMessage.format(new Object[]{name}));
                        return null;
                    }
                    new JavaServiceFileSystemCreateFolderJob(parent, name, (CommonNavigator)HandlerUtil.getActivePart((ExecutionEvent)event)).schedule();
                }
            }
            finally {
                newFile.dispose();
            }
        }
        return null;
    }
}

