/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphirePropertyPage;
import org.eclipse.swt.widgets.Composite;

public final class JavaServiceFilePropertyPage
extends SapphirePropertyPage {
    private FileMetadata metadata;

    public void setElement(IAdaptable element) {
        super.setElement(element);
        JavaServiceFile file = (JavaServiceFile)element.getAdapter(JavaServiceFile.class);
        this.metadata = (FileMetadata)FileMetadata.TYPE.instantiate();
        this.metadata.setPath("/" + file.path().toPortableString());
        this.metadata.setServerPath("/customer/scratch/" + file.path().toPortableString());
        this.metadata.setType(file.type());
        this.metadata.setSize(file.size());
        this.metadata.setLastModified(file.modified());
        this.init(this.metadata, DefinitionLoader.sdef(JavaServiceFilePropertyPage.class).form());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getApplyButton().setVisible(false);
    }

    public void dispose() {
        if (this.metadata != null) {
            this.metadata.dispose();
            this.metadata = null;
        }
        super.dispose();
    }

    public static interface FileMetadata
    extends Element {
        public static final ElementType TYPE = new ElementType(FileMetadata.class);
        @Label(standard="path")
        public static final ValueProperty PROP_PATH = new ValueProperty(TYPE, "Path");
        @Label(standard="server path")
        public static final ValueProperty PROP_SERVER_PATH = new ValueProperty(TYPE, "ServerPath");
        @Label(standard="type")
        public static final ValueProperty PROP_TYPE = new ValueProperty(TYPE, "Type");
        @Label(standard="size")
        @Type(base=Long.class)
        public static final ValueProperty PROP_SIZE = new ValueProperty(TYPE, "Size");
        @Label(standard="last modified")
        public static final ValueProperty PROP_LAST_MODIFIED = new ValueProperty(TYPE, "LastModified");

        public Value<String> getPath();

        public void setPath(String var1);

        public Value<String> getServerPath();

        public void setServerPath(String var1);

        public Value<String> getType();

        public void setType(String var1);

        public Value<Long> getSize();

        public void setSize(Long var1);

        public void setSize(String var1);

        public Value<String> getLastModified();

        public void setLastModified(String var1);
    }
}

