/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.fileSystem;

import oracle.eclipse.tools.cloud.ui.fileSystem.ICloudFile;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class CloudFileValidationServices {
    public static Status validate(String fullname) {
        if (!FileName.valid((String)fullname)) {
            return Status.createErrorStatus((String)("Invalid name: " + fullname));
        }
        return Status.createOkStatus();
    }

    public static class CloudFileNameValidator
    extends ValidationService {
        protected Status compute() {
            ICloudFile cf = (ICloudFile)this.context(ICloudFile.class);
            FileName fn = (FileName)cf.getName().content();
            if (fn != null) {
                String fullname = fn.full();
                return CloudFileValidationServices.validate(fullname);
            }
            return Status.createOkStatus();
        }
    }
}

