/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.wizard;

import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.ui.dev.wizard.ICommitConfig;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.osgi.service.prefs.BackingStoreException;

public class CommitMessageDialog
extends SapphireWizard<ICommitConfig>
implements IWorkbenchWizard {
    private String commitMsg;
    private String mavenGroupId;

    public String getCommitMsg() {
        return this.commitMsg;
    }

    public String getMavenGroupId() {
        return this.mavenGroupId;
    }

    public CommitMessageDialog(Repository repo, String msg) {
        DefinitionLoader.context(CommitMessageDialog.class);
        super(ICommitConfig.TYPE, DefinitionLoader.sdef(CommitMessageDialog.class).wizard("CommitMessageDialog"));
        this.commitMsg = null;
        this.mavenGroupId = null;
        this.commitMsg = msg;
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.cloud");
        String mavenGroupId = pref.get("DevCloudGroupId", null);
        ICommitConfig op = (ICommitConfig)this.element();
        op.setGroupId(mavenGroupId);
        op.setGenerateMavenBuildFiles(false);
        op.setUpdateHudsonJobs(false);
        op.setCommitMessage(this.commitMsg);
    }

    protected void performPostFinish() {
        ICommitConfig op = (ICommitConfig)this.element();
        this.mavenGroupId = (String)op.getGroupId().content();
        this.commitMsg = (String)op.getCommitMessage().content();
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.cloud");
        pref.put("DevCloudGroupId", this.mavenGroupId != null ? this.mavenGroupId : "");
        pref.put("GenerateMavenBuildFile", Boolean.toString((Boolean)op.getGenerateMavenBuildFiles().content()));
        pref.put("CreateHudsonJob", Boolean.toString((Boolean)op.getUpdateHudsonJobs().content()));
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

