/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.wizard;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.IGitConfig;
import oracle.eclipse.tools.cloud.dev.IMavenConfig;
import oracle.eclipse.tools.cloud.dev.IModulePomGenConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.maven.pom.IMavenProjectModel;
import oracle.eclipse.tools.cloud.maven.pom.PomModelFactory;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.osgi.service.prefs.BackingStoreException;

public class AddNewProjectsToCloudWizard
extends SapphireWizard<IPushProjectsToCloudOp>
implements IWorkbenchWizard {
    public AddNewProjectsToCloudWizard() {
        DefinitionLoader.context(AddNewProjectsToCloudWizard.class);
        super(IPushProjectsToCloudOp.TYPE, DefinitionLoader.sdef(AddNewProjectsToCloudWizard.class).wizard("AddNewProjectsToCloudWizard"));
    }

    protected void performPostFinish() {
        IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)this.element();
        String connName = (String)op.getConnectionName().content();
        String cloudProjName = (String)op.getCloudProjectId().content();
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.cloud");
        pref.put("DevCloudConnection", connName);
        pref.put("DevCloudProject", cloudProjName);
        String groupId = (String)op.getMavenBuildArtifactsGenConfig().getGroupId().content();
        if (groupId != null) {
            pref.put("DevCloudGroupId", groupId);
        }
        pref.put("GenerateMavenBuildFile", ((Boolean)op.getMavenBuildArtifactsGenConfig().getGenerateBuildFiles().content()).toString());
        pref.put("CreateHudsonJob", ((Boolean)op.getHudsonConfig().getCreateHudsonBuildJob().content()).toString());
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setProjectsToPush(Set<IProject> projectsToPush, CloudProject cloudProj, String remoteUrl) {
        if (projectsToPush != null) {
            IPushProjectsToCloudOp modelElm = (IPushProjectsToCloudOp)this.element();
            modelElm.setProjectsToPush(projectsToPush);
            modelElm.setCloudProject(cloudProj);
            if (cloudProj != null) {
                ICloudProfile cloudTarget = null;
                cloudTarget = cloudProj.getProfile();
                modelElm.setCloudProjectId(cloudProj.getProject().getIdentifier().toLowerCase());
                modelElm.setConnectionName((String)cloudTarget.getConnectionName().content());
            }
            IGitConfig gitCfg = modelElm.getGitConfig();
            StringBuffer s = new StringBuffer();
            Iterator<IProject> it = projectsToPush.iterator();
            while (it.hasNext()) {
                s.append(it.next().getName());
                if (!it.hasNext()) continue;
                s.append(", ");
            }
            String msg = String.format("Initial commit of project %s and dependencies.", s.toString());
            gitCfg.setCommitMessage(msg);
            IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.cloud");
            String mavenGroupId = pref.get("DevCloudGroupId", null);
            IMavenConfig mavenConfig = modelElm.getMavenBuildArtifactsGenConfig();
            mavenConfig.setGroupId(mavenGroupId);
            HashSet<String> projectNames = new HashSet<String>();
            for (IProject project : projectsToPush) {
                AddNewProjectsToCloudWizard.setDefaultArtifactIds(mavenConfig, project, projectNames);
            }
            if (remoteUrl != null) {
                IGitConfig gitConfig = modelElm.getGitConfig();
                gitConfig.setRemoteUrl(remoteUrl);
            }
        }
    }

    private static void setDefaultArtifactIds(IMavenConfig mavenConfig, IProject p, Set<String> projectNames) {
        if (projectNames.contains(p.getName())) {
            return;
        }
        projectNames.add(p.getName());
        ElementList modulePomGenCfgList = mavenConfig.getProjectModules();
        IModulePomGenConfig modulePomGenCfg = (IModulePomGenConfig)modulePomGenCfgList.insert();
        modulePomGenCfg.setProjectName(p.getName());
        IFile pomFile = p.getFile("pom.xml");
        if (pomFile.exists()) {
            try {
                IMavenProjectModel pomModel = PomModelFactory.loadWorkspaceFile((IFile)pomFile);
                modulePomGenCfg.setArtifactId((String)pomModel.getArtifactId().content());
            }
            catch (ResourceStoreException resourceStoreException) {}
        } else {
            modulePomGenCfg.setArtifactId(p.getName());
        }
        if (ComponentCore.createComponent((IProject)p) == null) {
            return;
        }
        Set list = WtpProjectUtil.findReferencedProjects((IProject)p);
        for (IProject childProj : list) {
            if (childProj == p) continue;
            AddNewProjectsToCloudWizard.setDefaultArtifactIds(mavenConfig, childProj, projectNames);
        }
    }
}

